;	File:	DISKBIOS.ASM
;	Date:	February 10, 1986
;
;	This code installed in Track 0 space of PC RP/M2
;	M: disk as INT 082H and replaces ROM BIOS INT 013H
;	for floppy disk I/O.
;
;	Provision is made for separate HD (bit 0) and H (bits 1-7)
;	parameters, both passed in the head byte via register DH.
;	This permits processing Kaypro 2X/4 type disks which have
;	preamble H different than HD.
;
;
ABS0	SEGMENT	AT	0
	ORG	078H
DMA	EQU	0	;DMA PORT
DISK_POINTER	LABEL	DWORD
ABS0	ENDS
;
DATA	SEGMENT	AT 40H
	ORG	03EH

SEEK_STATUS	DB	?
INT_FLAG	EQU	80H
MOTOR_STATUS	DB	?
MOTOR_COUNT	DB	?
MOTOR_WAIT	EQU	37
DISKETTE_STATUS	DB	?
TIME_OUT	EQU	80H
BAD_SEEK	EQU	40H
BAD_NEC	EQU	20H
BAD_CRC	EQU	10H
DMA_BOUNDARY	EQU	09H
BAD_DMA	EQU	8H
RECORD_NOT_FND	EQU	04H
WRITE_PROTECT	EQU	03H
BAD_ADDR_MARK	EQU	02H
BAD_CMD	EQU	01H
NEC_STATUS	DB	7 DUP(?)

DATA	ENDS

CODE	SEGMENT	PUBLIC
	ASSUME	CS:CODE,SS:CODE,ES:DATA,DS:DATA
	PUBLIC	DISKETTE_IO,DRVREND
;

DISKETTE_IO	PROC	FAR
BEGIN	=	$
            STI
            PUSH    BX
            PUSH    CX
            PUSH    DS
            PUSH    SI
            PUSH    DI
            PUSH    BP
            PUSH    DX
	AND	DH,0FEH		;mask H parameter
	SHR	DH,1
	MOV	CS:HSEL,DH	;Save the H byte
	POP	DX
	AND	DH,01H		;Mask the HD parameter
	PUSH	DX		;Save HD byte
            MOV     BP,SP
            CALL    FF3E
            CALL    EC85
            MOV     BX,0004
            CALL    EE6C
            MOV     MOTOR_COUNT,AH
            MOV     AH,DISKETTE_STATUS
            CMP     AH,01
            CMC
            POP     DX
            POP     BP
            POP     DI
            POP     SI
            POP     DS
            POP     CX
            POP     BX
            RET     2
;
DISKETTE_IO	ENDP
;
EC85	PROC	NEAR
         MOV     DH,AL
         AND     BYTE PTR MOTOR_STATUS,07FH
         OR      AH,AH
         JZ      ECB7
         DEC     AH
         JZ      ED07
         MOV     BYTE PTR DISKETTE_STATUS,00
       CMP     DL,04
       JNB     ECB1
         DEC     AH
         JZ      ED0B
         DEC     AH
         JNZ     ECA9
         JMP     ED3E

;
ECA9:    DEC     AH
         JZ      ED14
         DEC     AH
         JZ      ED18
ECB1:    MOV     BYTE PTR DISKETTE_STATUS,01
         RET
;
EC85	ENDP

;
ECB7 	PROC	NEAR
        MOV     DX,03F2H
        CLI
        MOV     AL,MOTOR_STATUS
        MOV     CL,04
        SHL     AL,CL
        TEST    AL,20H
        JNZ     ECD2
        TEST    AL,40H
        JNZ     ECD0
        TEST    AL,80H
        JZ      ECD4
        INC     AL
ECD0:   INC     AL
ECD2:   INC     AL
ECD4:   OR      AL,08H
            OUT     DX,AL
            MOV     BYTE PTR SEEK_STATUS,00
            MOV     BYTE PTR DISKETTE_STATUS,00
            OR      AL,04
            OUT     DX,AL
            STI
            CALL    EF12
            MOV     AL,NEC_STATUS
            CMP     AL,0C0H
            JZ      ECF5
            OR      BYTE PTR DISKETTE_STATUS,20H
            RET
ECF5:      MOV     AH,03
           CALL    EE41
           MOV     BX,0001
           CALL    EE6C
           MOV     BX,0003
           CALL    EE6C
ED06:      RET

ECB7	ENDP

ED07	PROC	NEAR
        MOV     AL,DISKETTE_STATUS
        RET
ED07	ENDP

ED0B	PROC	NEAR
        MOV     AL,46H
ED0D:   CALL    EEC8
        MOV     AH,0E6H
        JMP SHORT  ED4A
ED0B	ENDP


ED14	PROC	NEAR
        MOV     AL,42H
       JMP     ED0D
ED14	ENDP

ED18	PROC	NEAR
        OR      BYTE PTR MOTOR_STATUS,80H
        MOV     AL,4AH
        CALL    EEC8
        MOV     AH,4DH
        JMP SHORT ED4A
ED26:   MOV     BX,7
       CALL    EE6C
       MOV     BX,9
        CALL    EE6C
        MOV     BX,0FH
        CALL    EE6C
        MOV     BX,011H
        JMP     EDE9
ED18	ENDP

ED3E	PROC	NEAR
        OR      BYTE PTR MOTOR_STATUS,80H
        MOV     AL,4AH
        CALL    EEC8
        MOV     AH,0C5H
ED3E	ENDP

ED4A	PROC	NEAR
        JNB     ED54
        MOV     BYTE PTR DISKETTE_STATUS,09
         MOV     AL,00
         RET
ED54:    PUSH    AX
         PUSH    CX
         MOV     CL,DL
         MOV     AL,01
        SHL     AL,CL
         CLI
        MOV     BYTE PTR MOTOR_COUNT,0FFH
       TEST    MOTOR_STATUS,AL
       JNZ     ED99
       AND     BYTE PTR MOTOR_STATUS,0F0H
       OR      MOTOR_STATUS,AL
       STI
       MOV     AL,10H
       SHL     AL,CL
       OR      AL,DL
       OR      AL,0CH
       PUSH    DX
       MOV     DX,03F2H
       OUT     DX,AL
       POP     DX
       TEST    BYTE PTR MOTOR_STATUS,80H
       JZ      ED99
      MOV     BX,0014H
      CALL    EE6C
      OR      AH,AH
ED8F: JZ      ED99
       SUB     CX,CX
ED93:  LOOP    ED93
      DEC     AH
       JMP     ED8F
ED99:   STI
        POP     CX
        CALL    EE7D
        POP     AX
        MOV     BH,AH
        MOV     DH,00
        JB      EDF0
        MOV     SI,OFFSET EDF0
        NOP
        PUSH    SI
        CALL    EE41
        MOV     AH,[BP+01]
        SHL     AH,1
        SHL     AH,1
        AND     AH,04
        OR      AH,DL
        CALL    EE41
        CMP     BH,4DH
        JNZ     EDC4
        JMP     ED26
EDC4:   MOV     AH,CH
        CALL    EE41
	MOV	AH,CS:HSEL	;H byte
        CALL    EE41
        MOV     AH,CL
        CALL    EE41
        MOV     BX,7
        CALL    EE6C
        MOV     BX,9
        CALL    EE6C
        MOV     BX,0BH
        CALL    EE6C
        MOV     BX,0DH
EDE9:   CALL    EE6C
        POP     SI
        CALL    EF33
EDF0:  JB      EE37
       CALL    EF69
       JB      EE36
       CLD
       MOV     SI,42H
       LODSB
       AND     AL,0C0H
       JZ      EE3B
       CMP     AL,40H
       JNZ     EE2D
       LODSB
       SHL     AL,1
       MOV     AH,04
       JB      EE2F
       SHL     AL,1
       SHL     AL,1
       MOV     AH,10H
       JB      EE2F
       SHL     AL,1
       MOV     AH,08
       JB      EE2F
       SHL     AL,1
       SHL     AL,1
       MOV     AH,04
       JB      EE2F
       SHL     AL,1
       MOV     AH,03
       JB      EE2F
       SHL     AL,1
       MOV     AH,02
       JB      EE2F
EE2D:  MOV     AH,20H
EE2F:  OR      DISKETTE_STATUS,AH
       CALL    EFAE
EE36:  RET
EE37:   CALL    EF69
        RET
EE3B:   CALL    EFAE
        XOR     AH,AH
        RET

ED4A	ENDP

EE41	PROC	NEAR
        PUSH    DX
        PUSH    CX
        MOV     DX,03F4H
        XOR     CX,CX
EE48:   IN      AL,DX
        TEST    AL,40H
        JZ      EE59
        LOOP    EE48
EE4F:   OR      BYTE PTR DISKETTE_STATUS,80H
        POP     CX
        POP     DX
        POP     AX
        STC
        RET
EE59:   XOR     CX,CX
EE5B:   IN      AL,DX
        TEST    AL,80H
        JNZ     EE64
        LOOP    EE5B
        JMP     EE4F
EE64:    MOV     AL,AH
         MOV     DL,0F5H
         OUT     DX,AL
         POP     CX
         POP     DX
        RET

EE41	ENDP

EE6C	PROC	NEAR
	PUSH	DS
	SUB	AX,AX
	MOV	DS,AX
	ASSUME	DS:ABS0
	LDS	SI,DISK_POINTER
        SHR     BX,1
	MOV	AH,[BX+SI]		;original code
	POP	DS
	ASSUME	DS:DATA
        JB      EE41	;ON CARRY BIT
        RET

EE6C	ENDP

EE7D	PROC	NEAR
        MOV     AL,01
        PUSH    CX
        MOV     CL,DL
        ROL     AL,CL
        POP     CX
        TEST    SEEK_STATUS,AL
        JNZ     EE9E
        OR      SEEK_STATUS,AL
        MOV     AH,07
        CALL    EE41
        MOV     AH,DL
        CALL    EE41
        CALL    EF12
        JB      EEC7
EE9E:   MOV     AH,0FH
        CALL    EE41
        MOV     AH,DL
        CALL    EE41
        MOV     AH,CH
       CALL    EE41
        CALL    EF12
        PUSHF
        MOV     BX,12H
        CALL    EE6C
        PUSH    CX
EEB8:    MOV     CX,0226H
        OR      AH,AH
        JZ      EEC5
EEBF:   LOOP    EEBF
        DEC     AH
        JMP     EEB8
EEC5:   POP     CX
         POPF
EEC7:      RET

EE7D	ENDP

EEC8	PROC	NEAR
        PUSH    CX
        CLI
         OUT     DMA+0CH,AL	;DMA+12???
         PUSH    AX
         POP     AX
         OUT     DMA+0BH,AL
         MOV     AX,ES
         MOV     CL,04
         ROL     AX,CL
        MOV     CH,AL
         AND     AL,0F0H
        ADD     AX,BX
       JNB     EEE0
        INC     CH
EEE0:    PUSH    AX
          OUT     DMA+04,AL
       MOV     AL,AH
         OUT     DMA+04,AL
         MOV     AL,CH
        AND     AL,0FH
        OUT     81H,AL	;HIGH 4 BITS TO PAGE REGISTER
        MOV     AH,DH
        SUB     AL,AL
         SHR     AX,1
         PUSH    AX
         MOV     BX,0006
         CALL    EE6C
         MOV     CL,AH
         POP     AX
         SHL     AX,CL
         DEC     AX
         PUSH    AX
          OUT     DMA+05,AL
          MOV     AL,AH
          OUT     DMA+05,AL
          STI
          POP     CX
          POP     AX
          ADD     AX,CX
          POP     CX
          MOV     AL,02
          OUT     0AH,AL
          RET

EEC8	ENDP

EF12	PROC	NEAR
        CALL    EF33
        JB      EF2B
        MOV     AH,08
        CALL    EE41
        CALL    EF69
        JB      EF2B
        MOV     AL,NEC_STATUS
        AND     AL,60H
        CMP     AL,60H
        JZ      EF2C
        CLC
EF2B:   RET
EF2C:   OR      BYTE PTR DISKETTE_STATUS,40H
        STC
        RET

EF12	ENDP

EF33	PROC	NEAR
        STI
        PUSH    BX
        PUSH    CX
        MOV     BL,02
        XOR     CX,CX
EF3A:   TEST    BYTE PTR SEEK_STATUS,80H
        JNZ     EF4D
        LOOP    EF3A
        DEC     BL
        JNZ     EF3A
        OR      BYTE PTR DISKETTE_STATUS,80H
        STC
EF4D:   PUSHF
        AND     BYTE PTR SEEK_STATUS,7FH
        POPF
        POP     CX
        POP     BX
        RET

EF33	ENDP

; CODE WHICH NEVER GETS CALLED BECAUSE PC INTERRUPT ROUTINE HANDLES ITL 
EF57	PROC	NEAR
        STI
        PUSH    DS
        PUSH    AX
        CALL    FF3E
        OR      BYTE PTR SEEK_STATUS,80H
        MOV     AL,20H
        OUT     20H,AL
        POP     AX
        POP     DS
        IRET
; END OF UNCALLED CODE
EF57	ENDP


EF69	PROC	NEAR
        CLD
        MOV     DI,0042H
        PUSH    CX
        PUSH    DX
        PUSH    BX
        MOV     BL,07
EF72:   XOR     CX,CX
        MOV     DX,03F4H
EF77:   IN      AL,DX
        TEST    AL,80H
         JNZ     EF88
         LOOP    EF77
         OR      BYTE PTR DISKETTE_STATUS,80H
EF83:    STC
          POP     BX
          POP     DX
          POP     CX
          RET
EF88:    IN      AL,DX
          TEST    AL,40H
          JNZ     EF94
EF8D:    OR      BYTE PTR DISKETTE_STATUS,20H
          JMP     EF83
EF94:     INC     DX
         IN      AL,DX
         MOV     [DI],AL
         INC     DI
         MOV     CX,000AH
EF9C:     LOOP    EF9C
          DEC     DX
          IN      AL,DX
         TEST    AL,10H
      JZ      EFAA
        DEC     BL
        JNZ     EF72
        JMP     EF8D
EFAA:    POP     BX
         POP     DX
         POP     CX
         RET
EFAE	PROC	NEAR

        MOV     AL,NEC_STATUS+3
        CMP     AL,CH
        MOV     AL,NEC_STATUS+5
        JZ      EFC2
        MOV     BX,0008
        CALL    EE6C
        MOV     AL,AH
        INC     AL
EFC2:    SUB     AL,CL
         RET

EFAE	ENDP

FF3E	PROC	NEAR
	PUSH	AX
	MOV	AX,40H	;SET SEGMENT
	MOV	DS,AX
	POP	AX
	RET
FF3E	ENDP



EF69	ENDP

HSEL	LABEL	BYTE
	DB	0	;H portion of head select byte.

; PARAMETERS FOR KAYPRO 2X

DISK_BASE	LABEL	BYTE
	DB	11001111B	;
	DB	2		; 
	DB	MOTOR_WAIT
	DB	2	;512 BYTES/SEC
	DB	19	;EOT
	DB	8	;GAP LENGTH
	DB	0FFH	;DTL
	DB	1AH	;FORMAT GAP LENGTH
	DB	0F6H	;FORMAT VALUE
	DB	0	;HEAD SETTLE MS
	DB	2	;MOTOR START TIME 1/8 SEC UNIT
;
	ORG	($-BEGIN)+16-(($-BEGIN) MOD 16)
DRVREND	LABEL	BYTE


CODE	ENDS
	END
