;File:	RASM4.ASM
;Edit date:	86/10/04.
;Serial number 5
;
;	RP/M2 Assembler mnemonics table processor.
;
MTPORG	EQU	2A00H
;
;	Locations on page 1.
;	Print line buffer.
;
PLBFWA	EQU	010CH	;line buffer fwa
PLBSIZ	EQU	120	;line length
PLBFBP	EQU	PLBFWA+PLBSIZ	;buffer fill pointer
FPRCOL	EQU	16	;source line image starting column
;
;	Assembler control data.
;
TOKEN	EQU	PLBFBP+1	;current token
VALUE	EQU	TOKEN+1		;binary value
ACCLEN	EQU	VALUE+2		;accumulator length
ACCUM	EQU	ACCLEN+1	;accumulator fwa
ACCSIZ	EQU	64
EVALUE	EQU	ACCUM+ACCSIZ	;expression value
SYTOP	EQU	EVALUE+2	;current symbol table top
SYMAX	EQU	SYTOP+2		;symbol table lwa + 1
PASSN	EQU	SYMAX+2		;pass number, 0 or 1
HEXPC	EQU	PASSN+1		;current hex fill address
LOCCN	EQU	HEXPC+2		;assembler's location counter
SYBAS	EQU	LOCCN+2		;symbol table base
SYADR	EQU	SYBAS+2		;current symbol address
FIXED	EQU	5		;collision+length+value
;
;	Ascii character codes.
;
cr	EQU	0DH		;carriage return
lf	EQU	0AH		;line feed
eof	EQU	1AH		;control-z = end of file
tab	EQU	09H		;tabulate
;
;	Token definitions.
;
IDENT	EQU	1	;identifier
NUMBR	EQU	2	;number
STRNG	EQU	3	;string
SPECL	EQU	4	;other
;
;	Symbol types.
;
TCLB	EQU	 1	;code label
TDLB	EQU	 2	;data label
TEQU	EQU	 4	;defined by EQU
TSET	EQU	 5	;defined by SET
TMAC	EQU	 6	;defined by MACRO
TEXT	EQU	 8	;defined by EXT
TREF	EQU	11	;defined by REF
TGBL	EQU	12	;defined by GLOBAL
;
	ORG	MTPORG
	JMP	ENDMTP
	JMP	BSM	;binary search mnemonics table
	JMP	GMV	;get mnemonics type and value
;
;	Type codes.
;
;	Operators.
;
XBASE	EQU	0	;start of operator types
X1	EQU	XBASE+0		;*    multiply
X2	EQU	XBASE+1		;/    divide
X3	EQU	XBASE+2		;MOD  remainder
X4	EQU	XBASE+3		;SHL  shift left
X5	EQU	XBASE+4		;SHR  shift right
X6	EQU	XBASE+5		;+    add
X7	EQU	XBASE+6		;-    subtract
X8	EQU	XBASE+7		;-    unary minus
X9	EQU	XBASE+8		;NOT  negate
X10	EQU	XBASE+9		;AND  logical and
X11	EQU	XBASE+10	;OR   logical or
X12	EQU	XBASE+11	;XOR  exclusive or
X13	EQU	XBASE+12	;(    left parenthesis
X14	EQU	XBASE+13	;)    right
X15	EQU	XBASE+14	;,    separator
X16	EQU	XBASE+15	;cr   terminator
;
;	Instructions and pseudo-operations.
;
RT	EQU	X16+1		;machine instruction
PT	EQU	RT+1		;pseudo-operation
OBASE	EQU	PT+1		;base of machine code processors
;
;	Type codes for machine code processors.
;
O1	EQU	OBASE+1		;single byte instructions
O2	EQU	OBASE+2		;LXI
O3	EQU	OBASE+3		;DAD
O4	EQU	OBASE+4		;PUSH and POP
O5	EQU	OBASE+5		;CALL and JMP
O6	EQU	OBASE+6		;MOV
O7	EQU	OBASE+7		;MVI
O8	EQU	OBASE+8		;ACC immediate
O9	EQU	OBASE+9		;LDAX and STAX
O10	EQU	OBASE+10	;LHLD, SHLD, LDA, and STA
O11	EQU	OBASE+11	;ACC register
O12	EQU	OBASE+12	;INR and DCR
O13	EQU	OBASE+13	;INX and DCX
O14	EQU	OBASE+14	;RST
O15	EQU	OBASE+15	;IN and OUT
O16	EQU	OBASE+16	;CALLN
;
;	Table of character vector base addresses.
;
CINX	EQU	$
	DW	CHAR1		;1 char vector base
	DW	CHAR2		;2
	DW	CHAR3		;3
	DW	CHAR4		;4
	DW	CHAR5		;5
	DW	CHAR6		;end of vectors
CMAX	EQU	($-CINX)/2-1	;max mnemonic length
;
;	Mnemonic entries per character vector.
;
CLEN	EQU	$
	DB	(CHAR2-CHAR1)/1	;1 char entries
	DB	(CHAR3-CHAR2)/2	;2
	DB	(CHAR4-CHAR3)/3	;3
	DB	(CHAR5-CHAR4)/4	;4
	DB	(CHAR6-CHAR5)/5	;5
;
;	Type and value tables base addresses.
;
TVINX	EQU	$
	DW	TV1		;1 char mnemonic type and value table
	DW	TV2		;2
	DW	TV3		;3
	DW	TV4		;4
	DW	TV5		;5
;
;	Character vector strings, sorted into Ascii
;	ascending order for binary search routine.
;
CHAR1	EQU	$
	DB	cr,'()*+,-/'
	DB	'ABCDEHLM'
;
CHAR2	EQU	$
	DB	'DBDIDSDW'
	DB	'EIIFINOR'
	DB	'SP'
;
CHAR3	EQU	$
	DB	'ACIADCADDADI'
	DB	'ANAANDANICMA'
	DB	'CMCCMPCPIDAA'
	DB	'DADDCRDCXEND'
	DB	'EQUHLTINRINX'
	DB	'JMPLDALXIMOD'
	DB	'MOVMVINOPNOT'
	DB	'ORAORGORIOUT'
	DB	'POPPSWRALRAR'
	DB	'RETRLCRRCRST'
	DB	'SBBSBISETSHL'
	DB	'SHRSTASTCSUB'
	DB	'SUIXORXRAXRI'
;
CHAR4	EQU	$
	DB	'CALLENDMLDAXLHLDPCHL'
	DB	'PUSHSHLDSPHLSTAXXCHG'
	DB	'XTHL'
;
CHAR5	EQU	$
	DB	'CALLN'
	DB	'ENDIFRDLIBTITLE'
;
CHAR6	EQU	$	;end of character vectors
;
;	Type and value pairs for each mnemonic.
;
TV1	EQU	$		;1 char mnemonics
	DB	X16,10		;cr
	DB	X13,20		;(
	DB	X14,30		;)
	DB	X1,80		;*
	DB	X6,70		;+
	DB	X15,10		;,
	DB	X7,70		;-
	DB	X2,80		;/
	DB	RT,7		;A
	DB	RT,0		;B
	DB	RT,1		;C
	DB	RT,2		;D
	DB	RT,3		;E
	DB	RT,4		;H
	DB	RT,5		;L
	DB	RT,6		;M
;
TV2	EQU	$		;2 character mnemonics
	DB	PT,1		;DB
	DB	O1,0F3H		;DI
	DB	PT,2		;DS
	DB	PT,3		;DW
	DB	O1,0FBH		;EI
	DB	PT,8		;IF
	DB	O15,0DBH	;IN
	DB	X11,40		;OR
	DB	RT,6		;SP
;
TV3	EQU	$		;3 character mnemonics
	DB	O8,0CEH		;ACI
	DB	O11,88H		;ADC
	DB	O11,80H		;ADD
	DB	O8,0C6H		;ADI
	DB	O11,0A0H	;ANA
	DB	X10,50		;AND
	DB	O8,0E6H		;ANI
	DB	O1,2FH		;CMA
	DB	O1,3FH		;CMC
	DB	O11,0B8H	;CMP
	DB	O8,0FEH		;CPI
	DB	O1,27H		;DAA
	DB	O3,09H		;DAD
	DB	O12,05H		;DCR
	DB	O13,0BH		;DCX
	DB	PT,4		;END
	DB	PT,7		;EQU
	DB	O1,76H		;HLT
	DB	O12,04H		;INR
	DB	O13,03H		;INX
	DB	O5,0C3H		;JMP
	DB	O10,3AH		;LDA
	DB	O2,01H		;LXI
	DB	X3,80		;MOD
	DB	O6,40H		;MOV
	DB	O7,06H		;MVI
	DB	O1,00H		;NOP
	DB	X9,60		;NOT
	DB	O11,0B0H	;ORA
	DB	PT,10		;ORG
	DB	O8,0F6H		;ORI
	DB	O15,0D3H	;OUT
	DB	O4,0C1H		;POP
	DB	RT,6		;PSW
	DB	O1,17H		;RAL
	DB	O1,1FH		;RAR
	DB	O1,0C9H		;RET
	DB	O1,07H		;RLC
	DB	O1,0FH		;RRC
	DB	O14,0C7H	;RST
	DB	O11,98H		;SBB
	DB	O8,0DEH		;SBI
	DB	PT,11		;SET
	DB	X4,80		;SHL
	DB	X5,80		;SHR
	DB	O10,32H		;STA
	DB	O1,37H		;STC
	DB	O11,90H		;SUB
	DB	O8,0D6H		;SUI
	DB	X12,40		;XOR
	DB	O11,0A8H	;XRA
	DB	O8,0EEH		;XRI
;
TV4	EQU	$		;4 characer mnemonics
	DB	O5,0CDH		;CALL
	DB	PT,6		;ENDM
	DB	O9,0AH		;LDAX
	DB	O10,2AH		;LHLD
	DB	O1,0E9H		;PCHL
	DB	O4,0C5H		;PUSH
	DB	O10,22H		;SHLD
	DB	O1,0F9H		;SPHL
	DB	O9,02H		;STAX
	DB	O1,0EBH		;XCHG
	DB	O1,0E3H		;XTHL
;
TV5	EQU	$		;5 character mnemonics
	DB	O16,0EDH	;CALLN
	DB	PT,5		;ENDIF
	DB	PT,9		;RDLIB
	DB	PT,12		;TITLE
;
;	Conditional jums, calls, and returns, are
;	handled in a different way from all other
;	mnemonics.  The first character J, C, or R,
;	is indentified, and then the following table
;	is consulted to find a value for the condition.
;
SUFTAB	EQU	$
	DB	'NZ'		;0
	DB	'Z '		;1
	DB	'NC'		;2
	DB	'C '		;3
	DB	'PO'		;4
	DB	'PE'		;5
	DB	'P '		;6
	DB	'M '		;7
;
;	BSM - Binary search character tables.
;	Entry	 B = table length
;		 D = size of mnemonic
;		HL = table fwa
;	Exit	 Z = true, if mnemonic found, with
;		 A = index to entry found
;
BSM:	MVI	E,0FFH	;reset midpointer
	INR	B	;u=u+1
	MVI	C,0	;l=0
;
;	Find middle of lower (l) to upper (u) range.
;
BSM1:	MOV	A,B	;calc (u+l)/2
	ADD	C
	RAR
	CMP	E
	JZ	BSM6	;If same entry, no match
;
;	Calculate midpoint offset.
;
	MOV	E,A	;m=(u+l)/2
	PUSH	H	;save table fwa
	PUSH	D	;save m and size
	PUSH	B	;save u and l
	PUSH	H
	MOV	B,D	;B=C=size
	MOV	C,B
	MVI	D,0	;DE=m
	LXI	H,0	;multiply m * size
BSM2:	DAD	D
	DCR	B
	JNZ	BSM2	;loop m times
;
;	HL = offset to new midpoint of range.
;
	POP	D	;recover table fwa
	DAD	D	;HL=midpoint address
;
;	Compare this element with accumulator.
;
	LXI	D,ACCUM
BSM3:	LDAX	D
	CMP	M
	INX	D
	INX	H
	JNZ	BSM4	;If mismatch
;
	DCR	C
	JNZ	BSM3	;loop over mnemonic size
;
;	We have found the mnemonic.
;
	POP	B
	POP	D	;recover E = midpoint ordinal
	POP	H
	MOV	A,E
	RET
;
;	Pull either u or l into m, then
;	recompute a new midpoint to examine.
;	Carry is set if accumulator is lower.
;
BSM4:	POP	B	;recover u and l
	POP	D	;recover size and m
	POP	H	;recover table fwa
	JC	BSM5	;If we must look lower
;
;	We must look higher.  Pull lower end up.
;
	MOV	C,E	;set new lower limit l = m
	JMP	BSM1
;
;	We must look lower.  Pull higher end down.
;
BSM5:	MOV	B,E	;set new higher limit u = m
	JMP	BSM1
;
;	Process mnemonic not in this character string.
;
BSM6:	XRA	A	;return Z false
	INR	A
	RET
;
;	PFX - Check for J, C, or R, prefix.
;	The conditional jumps, calls, and returns
;	are treated as a special case.
;	Exit	 B = value
;		 C = type
;		 Z = true, if J, C, or R
;
PFX:	MVI	C,O5	;type
	LDA	ACCUM
	MVI B,0C2H ! CPI 'J' ! RZ	;If "J"
	MVI B,0C4H ! CPI 'C' ! RZ	;If "C"
	MVI	C,O1		;type
	MVI B,0C0H ! CPI 'R' ! RET	;If "R"
;
;	SFX - Check conditional suffix.
;	Exit	 Z = true, if suffix found, with
;		 B = suffix ordinal
;		HL = pointer to 3rd accum char
;
SFX:	LDA	ACCLEN
	CPI 4 ! JNC SFX4	;If length > 3
	CPI 3 ! JZ  SFX1	;If length = 3
	CPI 2 ! JNZ SFX4	;If length = 1
	LXI	H,ACCUM+2	;point to suffix
	MVI	M,' '
SFX1:	LXI	B,0008H		;B=00, C=table size
	LXI	D,SUFTAB
SFX2:	LXI	H,ACCUM+1	;point to accum suffix
	LDAX	D
	CMP	M
	INX	D
	JNZ	SFX3		;If mismatch
;
	LDAX	D		;get next char
	INX	H
	CMP	M
	RZ			;If hit
;
SFX3:	INX	D		;advance table
	INR	B		;advance suffex ordinal
	DCR	C
	JNZ	SFX2		;loop to end of table
;
;	Suffix not found.
;
	INR	C		;return Z false
	RET
;
;	Process improper suffix length.
;
SFX4:	XRA	A		;return Z false
	INR	A
	RET
;
;	GMV - Get mnemonic type and value.
;	Exit	 Z = true, if mnemonic found, with
;		 A = type
;		 B = value
;
GMV:	LDA	ACCLEN		;item length
	MOV	C,A
	DCR	A
	MOV E,A ! MVI D,0	;DE=length-1
	PUSH	D
	CPI	CMAX
	JNC	GMV2		;If item too long
;
	LXI	H,CLEN		;get number char vector entries
	DAD	D
	MOV	B,M		;B=upper bound
	LXI	H,CINX		;get char vector fwa
	DAD D ! DAD D
	MOV D,M ! INX H
	MOV H,M ! MOV L,D
	MOV	D,C		;D=mnemonic size
	CALL	BSM		;search for mnemonic
	JNZ	GMV1		;If not found
;
;	A = index to found mnemonic.
;
	POP	D		;restore mnemonic size-1
	LXI	H,TVINX		;get type and value table fwa
	DAD D ! DAD D
	MOV E,M ! INX H
	MOV D,M
	MOV L,A ! MVI H,0	;HL=entry ordinal
	DAD	H
	DAD	D
	MOV	A,M		;A = type
	INX	H
	MOV	B,M		;B = value
	RET
;
;	Check special case conditionals.
;
GMV1:	POP	D		;clear stack
	CALL	PFX		;check J, C, or R
	RNZ			;If not special case
;
;	Mnemonic may be conditional jump, call, or return.
;
	PUSH	B		;save type and value
	CALL	SFX		;check suffix
	MOV	A,B
	POP	B
	RNZ			;If not conditional
;
;	Process conditional jump, call, or return.
;
	ORA	A		;clear carry
	RAL ! RAL ! RAL
	ORA	B
	MOV	B,A		;B = value
	MOV	A,C		;A = type
	CMP	A		;set Z true
	RET
;
;	Item is longer than longest mnemonic.
;
GMV2:	POP	D		;clear stack
	XRA	A		;return Z false
	INR	A
	RET
;
ENDMTP	EQU	($ AND 0FF00H) + 100H
