/* uSim hostfile.h
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

typedef struct FileFCB FileFCB;
struct FileFCB {
	char fileName[8];
	char fileExtension[3];
	FILE *file;
	unsigned long position;
	unsigned count;
	int eof;
};

extern const char *FileNameFromFCB(FileFCB *fcb);

extern int HostFileRead(FileFCB *fcb, char *buffer);

extern int HostFileWrite(FileFCB *fcb, char *buffer);

extern int HostFileMake(FileFCB *fcb);

extern int HostFileDelete(FileFCB *fcb);

extern int HostFileClose(FileFCB *fcb);

extern int HostFileOpen(FileFCB *fcb);
