/* console.h
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#ifndef _CONSOLE_H_
#define _CONSOLE_H_

/* Y is vertical, X is horizontal, 0,0 is Upper Left */
#define kConsoleMaxX 80 /* 0 <= X < kConsoleMaxX */
#define kConsoleMaxY 24 /* 0 <= Y < kConsoleMaxY */

/* CONSOLE OUTPUT */

/* STANDARD DISPLAY CONTROL */
#define kConsoleBell            "\007"
#define kConsoleCursorLeft      "\010"
#define kConsoleTab             "\011"
#define kConsoleCursorDown      "\012"
#define kConsoleCursorUp        "\013"
#define kConsoleCursorRight     "\014"
#define kConsoleCarriageReturn  "\015"
#define kConsoleClearScreen     "\032"
#define kConsoleMoveCursor(x,y) "\033=%c%c", y + ' ', x + ' '
#define kConsoleHomeCursor      "\036"

#ifdef ADM31
/* ADM31 DISPLAY CONTROL */
#define kConsoleClearToEndOfLine "\033T"
#define kConsoleClearToEndOfScreen "\033Y"
#define kConsoleDeleteCharacter "\033W"
#define kConsoleDeleteLine "\033R"
#define kConsoleExitInsertMode "\033r"
#define kConsoleEnterInsertMode "\033q"
#define kConsoleNormalVideo "\033("
#define kConsoleReverseVideo "\033)"
#define kConsoleUnderline "\033G1"
#define kConsoleBlink "\033G2"
#define kConsoleNormalMode "\033G0"
#define kConsoleInsertLine "\033E"
#define kConsoleInsertCharacter "\033Q"
#endif

/* NON-STANDARD DISPLAY CONTROL */
#define kConsoleCleanLine     "\0330"
#define kConsoleRefreshScreen "\0331"
#define kConsoleCursorON      "\0332"
#define kConsoleCursorOFF     "\0333"
#define kConsoleSaveScreen    "\0334"
#define kConsoleRestoreScreen "\0335"
#define kConsoleAbout         "\0336"

/* NON-STANDARD DISPLAY COLOR */
#ifdef COLOR
#define kConsoleColorReset    "\033GC0"
#define kConsoleColorWhite    "\033GC1"
#define kConsoleColorRed      "\033GC2"
#define kConsoleColorGreen    "\033GC3"
#define kConsoleColorBlue     "\033GC4"
#define kConsoleColorCyan     "\033GC5"
#define kConsoleColorMagenta  "\033GC6"
#define kConsoleColorYellow   "\033GC7"
#else
#define kConsoleColorReset    ""
#define kConsoleColorWhite    ""
#define kConsoleColorRed      ""
#define kConsoleColorGreen    ""
#define kConsoleColorBlue     ""
#define kConsoleColorCyan     ""
#define kConsoleColorMagenta  ""
#define kConsoleColorYellow   ""
#endif

/* NON-STANDARD GRAPHICS CHARACTERS */
#define LOWERRIGHTCORNER	0x80
#define UPPERRIGHTCORNER	0x81
#define UPPERLEFTCORNER		0x82
#define LOWERLEFTCORNER		0x83
#define CROSS				0x84
#define HORIZONTALLINE		0x85
#define TEERIGHT			0x86
#define TEELEFT				0x87
#define TEEUP				0x88
#define TEEDOWN				0x89
#define VERTICALLINE		0x8A

extern int ConsoleOutput(int c);

/* CONSOLE INPUT */

#define kConsoleNotReady 0
#define kConsoleQuit     -1
#define kConsoleMonitor  -2
#define MOUSEKEY         -3
#define F9KEY            -4
#define F8KEY            -5
#define F7KEY            -6
#define F6KEY            -7
#define F5KEY            -8
#define F4KEY            -9
#define F3KEY            -10
#define F2KEY	         -11
#define F1KEY            -12
#define UPARROWKEY       -14
#define DOWNARROWKEY     -15
#define LEFTARROWKEY     -16
#define RIGHTARROWKEY    -17
#define REFRESHKEY       -18
#define INSERTKEY        -19
#define PAGEUPKEY        -20
#define PAGEDOWNKEY      -21
#define HELPKEY          -22
#define HOMEKEY          -23
#define DELETEKEY        0x7F
#define ESCAPEKEY        ('[' - '@')
#define RETURNKEY        ('M' - '@')
#define TABKEY           ('I' - '@')
#define BACKSPACEKEY     ('H' - '@')

extern int ConsolePushInput(const char *format, ...);

extern int ConsoleInput(unsigned waitSeconds);

extern void ConsoleMouse(unsigned *x, unsigned *y);

/* CONSOLE OPEN/CLOSE */

extern void ConsoleClose(void);

extern int
	ConsoleOpen(const char *windowTitle,
	            const char *aboutTitle,
	            const char *aboutText);

#endif