/* uSim cdev.h
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

enum DevCtl {
	DEVOPN = 0x10,
	DEVNAM = 0x20,
	DEVCLS = 0x30,
	DEVST  = 0x00,
	DEVERR = 0x20,
	DEVRD  = 0x40,
	DEVWR  = 0x80,
	DEVRW  = 0xC0,
	DEVTTY = 0x00,
	DEVCRT = 0x01,
	DEVUC1 = 0x02,
	DEVUC2 = 0x03,
	DEVPTR = 0x04,
	DEVUR1 = 0x05,
	DEVUR2 = 0x06,
	DEVUR3 = 0x07,
	DEVPTP = 0x08,
	DEVUP1 = 0x09,
	DEVUP2 = 0x0A,
	DEVUP3 = 0x0B,
	DEVLPT = 0x0C,
	DEVUL1 = 0x0D,
	DEVUL2 = 0x0E,
	DEVUL3 = 0x0F,
	kMaxCDev = 16
};

typedef struct CDev CDev;
typedef CDev *CDevPtr;

extern CDevPtr CDevIndexToPtr(unsigned n);

extern void CDevPoll(void);

extern void CDevClose(CDevPtr cDevPtr);

extern int CDevOpen(CDevPtr cDevPtr, const char *name);

extern Byte CDevStatus(CDevPtr cDevPtr, char *name);

extern Byte CDevInput(CDevPtr cDevPtr);

extern void CDevOutput(CDevPtr cDevPtr, Byte output);

extern char *CDevAttach(const char *cDev, const char *name);

extern void CDevDetach(const char *cDev);

extern void ShowCDevAttach(char *cDev);
