	TITLE	"uSIM ROM BOOTSTRAP FOR 60K CP/M -- i8080 VERSION"

; BOOT.ASM - uSim ROM BOOTSTRAP FOR 60K CP/M
; Copyright (C) 2000  Tsurishaddai Williamson, tsuri@earthlink.net
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

; NOTE: This must assemble to the same object as BOOT64.Z80.

	.8080
	.SOURCE	"SYSTEM.EQU"

; 63.5K CP/M LOCATIONS
MEMSIZ	EQU	64			; MEMORY SIZE, KILOBYTES
CPMVER	EQU	22			; CP/M VERSION
CCP	EQU	3200H+(MEMSIZ-20)*1024	; CCP BASE ADDRESS
BDOS	EQU	CCP+0800H		; BDOS BASE ADDRESS
BIOS	EQU	CCP+1600H		; BIOS BASE ADDRESS
DATA	EQU	BIOS+(2300H-1F80H)	; BIOS UNINITIALIZED DATA ADDRESS
REBOOT	EQU	0000H			; "JMP REBOOT" TO REBOOT
IOBYTE	EQU	0003H			; ADDRESS OF I/O BYTE VARIABLE
USRDSK	EQU	0004H			; ADDRESS OF USER NUMBER / CURRENT VARIABLE
SYSTEM	EQU	0005H			; "CALL SYSTEM" FOR SYSTEM CALL
USRFCB	EQU	005CH			; ADDRESS OF DEFAULT FILE CONTROL BLOCK
USRBUF	EQU	0080H			; ADDRESS OF DEFAULT I/O BUFFER
USRTPA	EQU	0100H			; ADDRESS OF TRANSIANT PROGRAM AREA

	ORG	0000H
	; PREPARE THE STACK POINTER (INVALID UNTIL RAM MAPPED IN)
	LXI	SP,0
	; COPY 64K ROM TO 64K RAM
	LXI	H, (MINROM SHL 8) OR (MINRAM)
NXTBNK:	MOV	A,H
	OUT	BANK2
	MOV	A,L
	OUT	BANK3
	LXI	B,BNKSIZ * 2
	LXI	D,BNKSIZ * 3
NXTBYT:	LDAX	B
	STAX	D
	INX	B
	INX	D
	MOV	A,D
	ORA	E
	JNZ	NXTBYT
	INR	H
	INR	L
	MOV	A,H
	CPI	MINROM + 4
	JNZ	NXTBNK
	; MAP IN 64K RAM
	MVI	A,MINRAM + 0
	OUT	BANK0
	MVI	A,MINRAM + 1
	OUT	BANK1
	MVI	A,MINRAM + 2
	OUT	BANK2
	MVI	A,MINRAM + 3
	OUT	BANK3
	; CONTINUE WITH BOOTSTRAP
	JMP	BOOT

; THE FOLLOWING WILL BE OVERLAYED BY THE DISK BOOT
	ORG	USRBUF
	HLT

; BOOT FROM DISK OR FROM ROM
	ORG	USRTPA
BOOT:	; MOUNT DISK A:
	MVI	A,0
	LXI	B,RAMDSK
	CALL	DSKMNT
	JNZ	ERROR	
	; READ TRACK 0, SECTOR 1 INTO USRBUF
	LXI	B,0000H
	CALL	SETTRK
	LXI	B,0001H
	CALL	SETSEC
	LXI	B,USRBUF
	CALL	SETDMA
	CALL	RDSEC
	LXI	B,NODSK
	JNZ	ERROR
	; EXAMINE THE FIRST INSTRUCTION IN USRBUF
	LDA	USRBUF
	LXI	H,0000H	; POINT TO "LXI SP"
	CMP	M
	JZ	GODSK	; BOOT FROM DISK IF "LXI SP"
	JMP	GOROM	; BOOT FROM ROM IF NOT "LXI SP"
RAMDSK:	DB	'RAMDISK',0
NODSK:	DB	'?DISK',10,13,0

; MOUNT A DISK
; IN: A = DISK NUMBER
; IN: BC = ADDRESS OF DISK FILE NAME
; OUT: NZ IF ERROR
DSKMNT:	OUT	DSKNUM	; SET DISK NUMBER
	IN	DSKCTL
	ANI	DSKCLS	; DO NOTHING IF ALREADY MOUNTED
	RZ
	CALL	SETDMA	; SET DISK FILE NAME
	MVI	A,DSKOPN
	OUT	DSKCTL	; MOUNT THE DISK
	IN	DSKCTL
	ANI	DSKERR	; RETURN NZ IF ERROR
	RET

; DROP INTO THE MONITOR IF THERE WAS AN ERROR
ERROR:	CALL	PUTS
	MVI	A,SYSMON
	OUT	SYSFLG
	JMP	BOOT	; TRY AGAIN TO BOOT

; BOOT FROM DISK
GODSK:	LXI	B,DSKMSG
	CALL	PUTS
	JMP	USRBUF	; RUN DISK BOOTSTRAP
DSKMSG:	DB	'[DISK BOOT]',10,13,0

; BOOT FROM ROM
GOROM:	LXI	B,ROMMSG
	CALL	PUTS
	JMP	BIOS	; RUN BIOS IN ROM
ROMMSG:	DB	'[ROM BOOT]',10,13,0

; PRINT A STRING
; IN: BC = ADDRESS OF ZERO-TERMINATED STRING
PUTS:	MVI	A,DEVTTY
	OUT	DEVCTL
	LDAX	B
	ORA	A
	RZ
	INX	B
	OUT	DEVDAT
	JMP	PUTS

; BIOS SET DMA POINTER FUNCTION
SETDMA:	MOV	A,B
	OUT	DMAHI
	MOV	A,C
	OUT	DMALO
	RET

; BIOS SET DISK TRACK FUNCTION
SETTRK:	MOV	A,B
	OUT	TRKHI
	MOV	A,C
	OUT	TRKLO
	RET

; BIOS SET DISK SECTOR FUNCTION
SETSEC:	DCX	B
	MOV	A,B
	OUT	SECHI
	MOV	A,C
	OUT	SECLO
	RET

; BIOS READ DISK SECTOR FUNCTION
RDSEC:	MVI	A,DSKRD
	OUT	DSKCTL
	IN	DSKCTL
	ANI	DSKERR
	MVI	A,1
	RNZ
	XRA	A
	RET

; THE FOLLOWING WILL BE OVERLAYED BY THE ROM BIOS
	ORG	BIOS
	LXI	B,NOSYS
	JMP	ERROR
NOSYS:	DB	'?SYSTEM',10,13,0

	END

