	TITLE	'CP/M BASIC DISK OPERATING SYSTEM (BDOS), VER 2.2'

; VERSION 2.2 JANUARY, 1980
; COPYRIGHT (C) 1978, 1979, 1980
; DIGITAL RESEARCH
; BOX 579, PACIFIC GROVE,
; CALIFORNIA, 93950

; Reorganized and reserialized May 9, 2000 by Tsurishaddai Williamson
; Based on the February 27, 1981 reconstruction by Clark A. Calkins

; 63.5K CP/M LOCATIONS
MEMSIZ	EQU	64			; MEMORY SIZE, KILOBYTES
CPMVER	EQU	22			; CP/M VERSION
CCP	EQU	3200H+(MEMSIZ-20)*1024	; CCP BASE ADDRESS
BDOS	EQU	CCP+0800H		; BDOS BASE ADDRESS
BIOS	EQU	CCP+1600H		; BIOS BASE ADDRESS
DATA	EQU	BIOS+(2300H-1F80H)	; BIOS UNINITIALIZED DATA ADDRESS
REBOOT	EQU	0000H			; "JMP REBOOT" TO REBOOT
IOBYTE	EQU	0003H			; ADDRESS OF I/O BYTE VARIABLE
USRDSK	EQU	0004H			; ADDRESS OF USER NUMBER / CURRENT VARIABLE
SYSTEM	EQU	0005H			; "CALL SYSTEM" FOR SYSTEM CALL
USRFCB	EQU	005CH			; ADDRESS OF DEFAULT FILE CONTROL BLOCK
USRBUF	EQU	0080H			; ADDRESS OF DEFAULT I/O BUFFER
USRTPA	EQU	0100H			; ADDRESS OF TRANSIANT PROGRAM AREA

; KEYBOARD CODES
CTLC	EQU	03H			; CONTROL-C (REBOOT)
CTLE	EQU	05H			; CONTROL-E (END OF LINE)
BS	EQU	08H			; CONTROL-H (BACKSPACE)
TAB	EQU	09H			; CONTROL-I (TAB)
LF	EQU	0AH			; CONTROL-J (LINE FEED)
FF	EQU	0CH			; CONTROL-L (FORM FEED)
CR	EQU	0DH			; CONTROL-M (CARRIAGE RETURN)
CTLP	EQU	10H			; CONTROL-P (TOGGLE PRINT)
CTLR	EQU	12H			; CONTROL-R (RETYPE LINE)
CTLS	EQU	13H			; CONTROL-S (START/STOP OUTPUT)
CTLU	EQU	15H			; CONTROL-U (CANCEL LINE)
CTLX	EQU	18H			; CONTROL-X (CANCEL)
CTLZ	EQU	1AH			; CONTROL-Z (END OF FILE)
DEL	EQU	7FH			; CONTROL-? (DELETE)

; BIOS JUMP TABLE
CBOOT	EQU	BIOS+(0*3)
WBOOT	EQU	BIOS+(1*3)
CONST	EQU	BIOS+(2*3)
CONIN	EQU	BIOS+(3*3)
CONOUT	EQU	BIOS+(4*3)
LSTOUT	EQU	BIOS+(5*3)
PUNOUT	EQU	BIOS+(6*3)
RDRIN	EQU	BIOS+(7*3)
HOMTRK	EQU	BIOS+(8*3)
SELDSK	EQU	BIOS+(9*3)
SETTRK	EQU	BIOS+(10*3)
SETSEC	EQU	BIOS+(11*3)
SETDMA	EQU	BIOS+(12*3)
RDSEC	EQU	BIOS+(13*3)
WRSEC	EQU	BIOS+(14*3)
LSTST	EQU	BIOS+(15*3)
SECXLT	EQU	BIOS+(16*3)

	ORG	BDOS

; THIS MUST MATCH THE SERIAL NUMBER IN THE CCP
SN2:	DB	020H,055H,053H,049H,04DH,020H

	JMP	SWITCH

; TABLE OF BDOS ERRORS
BADSEC:	DW	ERROR1
BADSEL:	DW	ERROR2
RODISK:	DW	ERROR3
ROFILE:	DW	ERROR4

; SWITCH TO BDOS FUNCTION
; IN: DE
; IN: C = FUNCTION NUMBER
SWITCH	XCHG
	SHLD	FCBPTR
	XCHG
	MOV	A,E
	STA	EPARAM
	LXI	H,0
	SHLD	RESULT
	DAD	SP
	SHLD	USRSTK
	LXI	SP,STACK
	XRA	A
	STA	AUTOFLAG
	STA	AUTO
	LXI	H,GOBACK
	PUSH	H
	MOV	A,C
	CPI	MAXFUN
	RNC
	MOV	C,E
	LXI	H,FUNTAB
	MOV	E,A
	MVI	D,0
	DAD	D
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	LHLD	FCBPTR
	XCHG
	PCHL

; TABLE OF BDOS FUNCTIONS
MAXFUN	EQU	41
FUNTAB:	DW	WBOOT	; 0
	DW	GETC	; 1
	DW	PUTC	; 2
	DW	GETRDR	; 3
	DW	PUNOUT	; 4
	DW	LSTOUT	; 5
	DW	DIRCIO	; 6
	DW	GETIOB	; 7
	DW	SETIOB	; 8
	DW	PUTS	; 9
	DW	RDBUF	; 10
	DW	GETCST	; 11
	DW	GETVER	; 12
	DW	RSTDSK	; 13
	DW	SETDSK	; 14
	DW	OPEN	; 15
	DW	CLOSE	; 16
	DW	FIRST	; 17
	DW	NEXT	; 18
	DW	ERASE	; 19
	DW	RDSEQ	; 20
	DW	WRSEQ	; 21
	DW	MAKE	; 22
	DW	RENAM	; 23
	DW	GETLOG	; 24
	DW	GETDSK	; 25
	DW	PUTDMA	; 26
	DW	GETALV	; 27
	DW	SETRO	; 28
	DW	GETROV	; 29
	DW	SETFIL	; 30
	DW	GETPB	; 31
	DW	GETUSR	; 32
	DW	RDRAN	; 33
	DW	WRRAN	; 34
	DW	FILSIZ	; 35
	DW	SETRAN	; 36
	DW	LOGOFF	; 37
	DW	RETURN	; 38
	DW	RETURN	; 39
	DW	WRRANZ	; 40

; BAD SECTOR READ OR WRITE
ERROR1:	LXI	H,ERR1M
	CALL	PERROR
	CPI	CTLC
	JZ	REBOOT
	RET

; BAD DISK SELECT
ERROR2:	LXI	H,ERR2M
	JMP	ERROR5

; DISK IS READ-ONLY
ERROR3:	LXI	H,ERR3M
	JMP	ERROR5

; FILE IS READ-ONLY
ERROR4:	LXI	H,ERR4M

; PRINT ERROR MESSAGE AND REBOOT
; IN: HL = ADDRESS OF ERROR MESSAGE
ERROR5:	CALL	PERROR
	JMP	REBOOT

ERRM1:	DB	'Bdos Err On '
ERRM2:	DB	' : $'
ERR1M:	DB	'Bad Sector$'
ERR2M:	DB	'Select$'
ERR4M:	DB	'File '
ERR3M:	DB	'R/O$'

; PRINT ERROR MESSAGE
; IN: HL = ADDRESS OF $-TERMINATED STRING
PERROR:	PUSH	H
	CALL	PCRLF
	LDA	DSKNUM
	ADI	'A'
	STA	ERRM2
	LXI	B,ERRM1
	CALL	PMESG
	POP	B
	CALL	PMESG

; INPUT A CHARACTER, NO ECHO
GETC2:	LXI	H,CHRBUF
	MOV	A,M
	MVI	M,0
	ORA	A
	RNZ
	JMP	CONIN

; INPUT AND ECHO A CHARACTER
GETC1	CALL	GETC2
	CALL	CHKC
	RC
	PUSH	PSW
	MOV	C,A
	CALL	PUTC
	POP	PSW
	RET

; CHECK FOR CONTROL CHARACTER
; IN: A = CHARACTER
; OUT: SET Z IF CARRIAGE RETURN, LINE FEED, BACK SPACE OR TAB
; OUT: SET C IF ANY OTHER CONTROL CHARACTER
CHKC	CPI	CR
	RZ
	CPI	LF
	RZ
	CPI	TAB
	RZ
	CPI	BS
	RZ
	CPI	' '
	RET

; CHECK FOR CTL-C OR CTL-S DURING CONSOLE OUTPUT
; OUT: A = 1 IF KEY PRESSED
CKCON:	LDA	CHRBUF
	ORA	A
	JNZ	CKCON2
	CALL	CONST
	ANI	01H
	RZ
	CALL	CONIN
	CPI	CTLS
	JNZ	CKCON1
	CALL	CONIN
	CPI	CTLC
	JZ	REBOOT
	XRA	A
	RET
CKCON1	STA	CHRBUF
CKCON2	MVI	A,1
	RET

; PRINT A CHARACTER, MAYBE PRINT, CHECK FOR CTL-C OR CTL-S
; IN: C = CHARACTER
PUTC2	LDA	XOFF
	ORA	A
	JNZ	PUTC3
	PUSH	B
	CALL	CKCON
	POP	B
	PUSH	B
	CALL	CONOUT
	POP	B
	PUSH	B
	LDA	PRTFLAG
	ORA	A
	CNZ	LSTOUT
	POP	B
PUTC3	MOV	A,C
	LXI	H,CURPOS
	CPI	DEL
	RZ
	INR	M
	CPI	' '
	RNC
	DCR	M
	MOV	A,M
	ORA	A
	RZ
	MOV	A,C
	CPI	BS
	JNZ	PUTC4
	DCR	M
	RET
PUTC4	CPI	LF
	RNZ
	MVI	M,0
	RET

; PRINT A CHARACTER, USE ^X FORMAT IF IT IS A CONTROL CHARACTER
SHOWC	MOV	A,C
	CALL	CHKC
	JNC	PUTC
	PUSH	PSW
	MVI	C,'^'
	CALL	PUTC2
	POP	PSW
	ORI	'@'
	MOV	C,A

; SYSTEM FUNCTION #2: CONSOLE OUTPUT, EXPAND TABS
PUTC	MOV	A,C
	CPI	TAB
	JNZ	PUTC2
PUTC1	MVI	C,' '
	CALL	PUTC2
	LDA	CURPOS
	ANI	07H
	JNZ	PUTC1
	RET

BACKUP	CALL	BACK1
	MVI	C,' '
	CALL	CONOUT
BACK1	MVI	C,BS
	JMP	CONOUT

; NEW LINE, PRINT '#' AT THE END AND START OVER
NEWLN	MVI	C,'#'
	CALL	PUTC2
	CALL	PCRLF
NEWLN1	LDA	CURPOS	
	LXI	H,STARTING
	CMP	M
	RNC
	MVI	C,' '
	CALL	PUTC2
	JMP	NEWLN1

; PRINT A CRLF
PCRLF	MVI	C,CR
	CALL	PUTC2
	MVI	C,LF
	JMP	PUTC2

; PRINT A MESSAGE
; IN: BC = ADDRESS OF $-TERMINATED STRING
PMESG	LDAX	B
	CPI	'$'
	RZ
	INX	B
	PUSH	B
	MOV	C,A
	CALL	PUTC
	POP	B
	JMP	PMESG

; SYSTEM FUNCTION #10: READ THE CONSOLE BUFFER
RDBUF	LDA	CURPOS	;use present location as starting one.
	STA	STARTING
	LHLD	FCBPTR	;get the maximum buffer space.
	MOV	C,M
	INX	H	;point to first available space.
	PUSH	H	;and save.
	MVI	B,0	;keep a character count.
RDBUF1	PUSH	B
	PUSH	H
RDBUF2	CALL	GETC2	;get the next input character.
	ANI	7FH	;strip bit 7.
	POP	H	;reset registers.
	POP	B
	CPI	CR	;en of the line?
	JZ	RDBUF17
	CPI	LF
	JZ	RDBUF17
	CPI	BS	;how about a backspace?
	JNZ	RDBUF3
	MOV	A,B	;yes, but ignore at the beginning of the line.
	ORA	A
	JZ	RDBUF1
	DCR	B	;ok, update counter.
	LDA	CURPOS	;if we backspace to the start of the line,
	STA	XOFF	;treat as a cancel (control-x).
	JMP	RDBUF10
RDBUF3	CPI	DEL	;user typed a rubout?
	JNZ	RDBUF4
	MOV	A,B	;ignore at the start of the line.
	ORA	A
	JZ	RDBUF1
	MOV	A,M	;ok, echo the prevoius character.
	DCR	B	;and reset pointers (counters).
	DCX	H
	JMP	RDBUF15
RDBUF4	CPI	CTLE	;physical end of line?
	JNZ	RDBUF5
	PUSH	B	;yes, do it.
	PUSH	H
	CALL	PCRLF
	XRA	A	;and update starting position.
	STA	STARTING
	JMP	RDBUF2
RDBUF5	CPI	CTLP	;control-p?
	JNZ	RDBUF6
	PUSH	H	;yes, flip the print flag filp-flop byte.
	LXI	H,PRTFLAG
	MVI	A,1	;PRTFLAG=1-PRTFLAG
	SUB	M
	MOV	M,A
	POP	H
	JMP	RDBUF1
RDBUF6	CPI	CTLX	;control-x (cancel)?
	JNZ	RDBUF8
	POP	H
RDBUF7	LDA	STARTING;yes, backup the cursor to here.
	LXI	H,CURPOS
	CMP	M
	JNC	RDBUF	;done yet?
	DCR	M	;no, decrement pointer and output back up one space.
	CALL	BACKUP
	JMP	RDBUF7
RDBUF8	CPI	CTLU	;cntrol-u (cancel line)?
	JNZ	RDBUF9
	CALL	NEWLN	;start a new line.
	POP	H
	JMP	RDBUF
RDBUF9	CPI	CTLR	;control-r?
	JNZ	RDBUF14
RDBUF10	PUSH	B	;yes, start a new line and retype the old one.
	CALL	NEWLN
	POP	B
	POP	H
	PUSH	H
	PUSH	B
RDBUF11	MOV	A,B	;done whole line yet?
	ORA	A
	JZ	RDBUF12
	INX	H	;nope, get next character.
	MOV	C,M
	DCR	B	;count it.
	PUSH	B
	PUSH	H
	CALL	SHOWC	;and display it.
	POP	H
	POP	B
	JMP	RDBUF11
RDBUF12	PUSH	H	;done with line. If we were displaying
	LDA	XOFF	;then update cursor position.
	ORA	A
	JZ	RDBUF2
	LXI	H,CURPOS;because this line is shorter, we must
	SUB	M	;back up the cursor (not the screen however)
	STA	XOFF	;some number of positions.
RDBUF13	CALL	BACKUP	;note that as long as (XOFF) is non
	LXI	H,XOFF;zero, the screen will not be changed.
	DCR	M
	JNZ	RDBUF13
	JMP	RDBUF2	;now just get the next character.
;
;   Just a normal character, put this in our buffer and echo.
;
RDBUF14	INX	H
	MOV	M,A	;store character.
	INR	B	;and count it.
RDBUF15	PUSH	B
	PUSH	H
	MOV	C,A	;echo it now.
	CALL	SHOWC
	POP	H
	POP	B
	MOV	A,M	;was it an abort request?
	CPI	CTLC	;control-c abort?
	MOV	A,B
	JNZ	RDBUF16
	CPI	1	;only if at start of line.
	JZ	0
RDBUF16	CMP	C	;nope, have we filled the buffer?
	JC	RDBUF1
RDBUF17	POP	H	;yes end the line and return.
	MOV	M,B
	MVI	C,CR
	JMP	PUTC2	;output (cr) and return.

; SYSTEM FUNCTION #1: CONSOLE INPUT
GETC	CALL	GETC1	;get and echo.
	JMP	SETRES	;save status and return.

; SYSTEM FUNCTION #3: READER INPUT
GETRDR	CALL	RDRIN	;get a character from reader, set status and return.
	JMP	SETRES

; SYSTEM FUNCTION #6: DIRECT CONSOLE I/O
DIRCIO:	MOV	A,C	;test for (FF).
	INR	A
	JZ	DIRC1
	INR	A	;test for (FE).
	JZ	CONST
	JMP	CONOUT	;just output (C).
DIRC1:	CALL	CONST	;this is an input request.
	ORA	A
	JZ	GOBACK1	;not ready? Just return (directly).
	CALL	CONIN	;yes, get character.
	JMP	SETRES	;set status and return.

; SYSTEM FUNCTION #7: GET I/O BYTE
GETIOB:	LDA	IOBYTE
	JMP	SETRES

; SYSTEM FUNCTION #8: SET I/O BYTE
SETIOB:	LXI	H,IOBYTE
	MOV	M,C
	RET

; SYSTEM FUNCTION #9: PRINT STRING
PUTS:	XCHG
	MOV	C,L
	MOV	B,H
	JMP	PMESG

; SYSTEM FUNCTION #11: GET CONSOLE STATUS
GETCST:	CALL	CKCON
; SET THE RESULT CODE
; IN: A = RESULT
SETRES	STA	RESULT
RETURN:	RET

; SET RESULT TO ONE FOR READ OR WRITE ERROR
IOERR1	MVI	A,1
	JMP	SETRES
;
XOFF	DB	0	;output flag (non zero means no output).
STARTING:DB	2	;starting position for cursor.
CURPOS	DB	0	;cursor position (0=start of line).
PRTFLAG	DB	0	;printer flag (control-p toggle). List if non zero.
CHRBUF	DB	0	;single input character buffer.
USRSTK:	DW	0	;save users stack pointer here.

	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
STACK	EQU	$

USRNUM	DB	0	;current user number.
DSKNUM	DB	0	;currently active drive.
FCBPTR	DW	0	;save (DE) parameters here on entry.
RESULT	DW	0	;status returned from bdos function.

SLCTERR	LXI	H,BADSEL
; PC = ADDRESS AT HL
JMPHL	MOV	E,M
	INX	H
	MOV	D,M	;now (DE) contain the desired address.
	XCHG
	PCHL

; MEMORY COPY
; IN: DE = SOURCE ADDRESS
; IN: HL = DESTINATION ADDRESS
; IN: C = COUNT
MEMCPY	INR	C
MEMCP1	DCR	C
	RZ
	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	JMP	MEMCP1

; SELECT A NEW DISK
; IN: DSKNUM = DISK NUMBER
SELECT:	LDA	DSKNUM
	MOV	C,A
	CALL	SELDSK
	MOV	A,H
	ORA	L
	RZ		; HL = ADDRESS OF THE DISK PARAMETER BLOCK
	MOV	E,M
	INX	H
	MOV	D,M	; DE = ADDRESS OF THE SECTOR TRANSLATION TABLE
	INX	H
	SHLD	DIRPOS	; DIRPOS = ADDRESS OF DIRPOS IN THE PARAMETER BLOCK
	INX	H
	INX	H
	SHLD	TRKNUM	; TRKNUM = ADDRESS OF TRKNUM IN THE PARAMETER BLOCK
	INX	H
	INX	H
	SHLD	SECNUM	; SECNUM = ADDRESS OF SECNUM IN THE PARAMETER BLOCK
	INX	H
	INX	H
	XCHG
	SHLD	DSKXLT	; DSKXLT = ADDRESS OF THE SECTOR TRANSLATION TABLE
	LXI	H,DIRPTR;put the next 8 bytes here.
	MVI	C,8	;they consist of the directory buffer
	CALL	MEMCPY	;pointer, parameter block pointer,
	LHLD	PBPTR	;check and allocation vectors.
	XCHG
	LXI	H,DSKSPT	;move parameter block into our ram.
	MVI	C,15	;it is 15 bytes long.
	CALL	MEMCPY
	LHLD	DSKDSM	;check disk size.
	MOV	A,H	;more than 256 blocks on this?
	LXI	H,BIGDSK
	MVI	M,0FFH	;set to samll.
	ORA	A
	JZ	SELECT1
	MVI	M,0	;wrong, set to large.
SELECT1	MVI	A,0FFH	;clear the zero flag.
	ORA	A
	RET

; HOME THE DISK HEAD, CLEAR THE TRKNUM AND SECNUM POINTER
HOME:	CALL	HOMTRK	;home the head.
	XRA	A
	LHLD	TRKNUM	;set our track pointer also.
	MOV	M,A
	INX	H
	MOV	M,A
	LHLD	SECNUM	;and our sector pointer.
	MOV	M,A
	INX	H
	MOV	M,A
	RET

; READ A SECTOR FROM THE DISK, CHECK FOR ERROR
RDDSK:	CALL	RDSEC	; CALL BIOS TO READ FROM THE DISK
	JMP	IORET	; CHECK FOR ERROR

; WRITE A SECTOR TO THE DISK, CHECK FOR ERROR
WRDSK:	CALL	WRSEC	; CALL BIOS TO WRITE TO THE DISK
IORET:	ORA	A
	RZ
	LXI	H,BADSEC; ABORT IF BAD SECTOR
	JMP	JMPHL

; SELECT THE TRACK AND SECTOR FOR A BLOCK
TRKSEC	LHLD	FPOS	;get position of last accessed file
	MVI	C,2	;in directory and compute sector #.
	CALL	SHRN	;sector #=file-position/4.
	SHLD	PHYSEC	;save this as the block number of interest.
	SHLD	CKSBLK	;what's it doing here too?
;
;   if the sector number has already been set (PHYSEC), enter
; at this point.
;
TRKSEC1	LXI	H,PHYSEC
	MOV	C,M	;move sector number into (BC).
	INX	H
	MOV	B,M
	LHLD	SECNUM	;get current sector number and
	MOV	E,M	;move this into (DE).
	INX	H
	MOV	D,M
	LHLD	TRKNUM	;get current track number.
	MOV	A,M	;and this into (HL).
	INX	H
	MOV	H,M
	MOV	L,A
TRKSEC2	MOV	A,C	;is desired sector before current one?
	SUB	E
	MOV	A,B
	SBB	D
	JNC	TRKSEC3
	PUSH	H	;yes, decrement sectors by one track.
	LHLD	DSKSPT	;get sectors per track.
	MOV	A,E
	SUB	L
	MOV	E,A
	MOV	A,D
	SBB	H
	MOV	D,A	;now we have backed up one full track.
	POP	H
	DCX	H	;adjust track counter.
	JMP	TRKSEC2
TRKSEC3	PUSH	H	;desired sector is after current one.
	LHLD	DSKSPT	;get sectors per track.
	DAD	D	;bump sector pointer to next track.
	JC	TRKSEC4
	MOV	A,C	;is desired sector now before current one?
	SUB	L
	MOV	A,B
	SBB	H
	JC	TRKSEC4
	XCHG		;not yes, increment track counter
	POP	H	;and continue until it is.
	INX	H
	JMP	TRKSEC3
;
;   here we have determined the track number that contains the
; desired sector.
;
TRKSEC4	POP	H	; HL has the track number
	PUSH	B	; push frog
	PUSH	D	; push sector number
	PUSH	H	; push track number
	XCHG		; DE has track number
	LHLD	DSKOFF
	DAD	D	; HL is now track number + offset
	MOV	B,H
	MOV	C,L	; BC has track number + offset
	CALL	SETTRK	; select the track.
	POP	D	; DE has track number
	LHLD	TRKNUM
	MOV	M,E
	INX	H
	MOV	M,D	; TRKNUM has track number
	POP	D	; DE has sector number
	LHLD	SECNUM
	MOV	M,E
	INX	H
	MOV	M,D	; SECNUM has sector number
	POP	B	; BC has frog, DE has sector number
	MOV	A,C
	SUB	E
	MOV	C,A
	MOV	A,B
	SBB	D	; BC = BC - DE
	MOV	B,A	; BC has sector offset for translation table
	LHLD	DSKXLT
	XCHG		; DE = address of translation table
	CALL	SECXLT	; translate the sector number
	MOV	C,L
	MOV	B,H	; BC has sector number
	JMP	SETSEC	; select the sector

; COMPUTE BLOCK NUMBER FROM SAVNREC AND SAVEXT
BLOCK2:	LXI	H,DSKBHS;get logical to physical conversion.
	MOV	C,M	;note that this is base 2 log of ratio.
	LDA	SAVNREC	;get record number.
BLOCK3:	ORA	A	;compute (A)=(A)/2^DSKBHS.
	RAR
	DCR	C
	JNZ	BLOCK3
	MOV	B,A	;save result in (B).
	MVI	A,8
	SUB	M
	MOV	C,A	;compute (C)=8-DSKBHS.
	LDA	SAVEXT
BLOCK4:	DCR	C	;compute (A)=SAVEXT*2^(8-DSKBHS).
	JZ	BLOCK5
	ORA	A
	RAL
	JMP	BLOCK4
BLOCK5:	ADD	B
	RET

; EXTRACT PHYSICAL BLOCK NUMBER FROM THE FCB
; IN: BC = LOGICAL BLOCK NUMBER
; OUT: HL = PHYSICAL BLOCK NUMBER
EXTBLK	LHLD	FCBPTR	;get fcb address.
	LXI	D,16	;block numbers start 16 bytes into fcb.
	DAD	D
	DAD	B
	LDA	BIGDSK	;are we using a big-disk?
	ORA	A
	JZ	EXTBL1
	MOV	L,M	;no, extract an 8 bit number from the fcb.
	MVI	H,0
	RET
EXTBL1	DAD	B	;yes, extract a 16 bit number.
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG		;return in (HL).
	RET

; COMPUTE PHYSICAL BLOCK NUMBER
BLOCK:	CALL	BLOCK2
	MOV	C,A
	MVI	B,0
	CALL	EXTBLK
	SHLD	PHYSEC
	RET
;
;   Check for a zero block number (unused).
;
CHKBLK	LHLD	PHYSEC
	MOV	A,L	;is it zero?
	ORA	H
	RET
;
;   Adjust physical block (PHYSEC) and convert to logical
; sector (LOGSEC). This is the starting sector of this block.
; The actual sector of interest is then added to this and the
; resulting sector number is stored back in (PHYSEC). This
; will still have to be adjusted for the track number.
;
LOGICAL	LDA	DSKBHS	;get log2(physical/logical sectors).
	LHLD	PHYSEC	;get physical sector desired.
LOGICL1	DAD	H	;compute logical sector number.
	DCR	A	;note logical sectors are 128 bytes long.
	JNZ	LOGICL1
	SHLD	LOGSEC	;save logical sector.
	LDA	DSKBLM	;get block mask.
	MOV	C,A
	LDA	SAVNREC	;get next sector to access.
	ANA	C	;extract the relative position within physical block.
	ORA	L	;and add it too logical sector.
	MOV	L,A
	SHLD	PHYSEC	;and store.
	RET

; GET A POINTER TO THE EXTENT BYTE
; IN: FCBPTR = POINTER TO USER'S FCB
; OUT: HL = ADDRESS OF EXTENT BYTE
SETEXT:	LHLD	FCBPTR
	LXI	D,12
	DAD	D
	RET

; GET POINTERS TO THE RECORD COUNT AND NEXT RECORD NUMBER BYTES
; IN: FCBPTR = POINTER TO USER'S FCB
; OUT: HL = ADDRESS OF RECORD COUNT BYTE
; OUT: DE = ADDRESS OF NEXT RECORD NUMBER BYTE
SETREC:	LHLD	FCBPTR
	LXI	D,15
	DAD	D
	XCHG
	LXI	H,17
	DAD	D
	RET
;
;   Save current file data from fcb.
;
STRDATA	CALL	SETREC
	MOV	A,M	;get and store record count byte.
	STA	SAVNREC
	XCHG
	MOV	A,M	;get and store next record number byte.
	STA	SAVNXT
	CALL	SETEXT	;point to extent byte.
	LDA	DSKEXT	;get extent mask.
	ANA	M
	STA	SAVEXT	;and save extent here.
	RET
;
;   Set the next record to access. If (WRMODE) is set to 2, then
; the last record byte (SAVNREC) has the correct number to access.
; For sequential access, (WRMODE) will be equal to 1.
;
SETNREC	CALL	SETREC
	LDA	WRMODE	;get sequential flag (=1).
	CPI	2	;a 2 indicates that no adder is needed.
	JNZ	STNREC1
	XRA	A	;clear adder (random access?).
STNREC1	MOV	C,A
	LDA	SAVNREC	;get last record number.
	ADD	C	;increment record count.
	MOV	M,A	;and set fcb's next record byte.
	XCHG
	LDA	SAVNXT	;get next record byte from storage.
	MOV	M,A	;and put this into fcb as number of records used.
	RET

; SHIFT RIGHT N BITS
; IN: C = NUMBER OF BITS
; IN: HL = 16-BIT VALUE
; OUT: HL = 16-BIT VALUE
SHRN:	INR	C
SHRN1:	DCR	C
	RZ
	MOV	A,H
	ORA	A
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	JMP	SHRN1

; COMPUTE THE CHECKSUM FOR THE DIRECTORY BUFFER
; IN: DIRPTR -- POINTER TO DIRECTORY BUFFER
; OUT: A = CHECKSUM
CKSUM:	MVI	C,128	;length of buffer.
	LHLD	DIRPTR	;get its location.
	XRA	A	;clear summation byte.
CKSUM1:	ADD	M	;and compute sum ignoring carries.
	INX	H
	DCR	C
	JNZ	CKSUM1
	RET

; SHIFT LEFT N BITS
; IN: C = NUMBER OF BITS
; IN: HL = 16-BIT VALUE
; OUT: HL = 16-BIT VALUE
SHLN:	INR	C
SHLN1:	DCR	C
	RZ
	DAD	H
	JMP	SHLN1

;   Routine to set a bit in a 16 bit value contained in (BC).
; The bit set depends on the current drive selection.
;
SETBIT	PUSH	B	;save 16 bit word.
	LDA	DSKNUM	;get active drive.
	MOV	C,A
	LXI	H,1
	CALL	SHLN	;shift bit 0 into place.
	POP	B	;now 'or' this with the original word.
	MOV	A,C
	ORA	L
	MOV	L,A	;low byte done, do high byte.
	MOV	A,B
	ORA	H
	MOV	H,A
	RET
;
;   Extract the write protect status bit for the current drive.
; The result is returned in (A), bit 0.
;
GETWPRT	LHLD	WRTPRT	;get status bytes.
	LDA	DSKNUM	;which drive is current?
	MOV	C,A
	CALL	SHRN	;shift status such that bit 0 is the
	MOV	A,L	;one of interest for this drive.
	ANI	01H	;and isolate it.
	RET
;
;   Function to write protect the current disk.
;
SETRO	LXI	H,WRTPRT;point to status word.
	MOV	C,M	;set (BC) equal to the status.
	INX	H
	MOV	B,M
	CALL	SETBIT	;and set this bit according to current drive.
	SHLD	WRTPRT	;then save.
	LHLD	DSKDRM	;now save directory size limit.
	INX	H	;remember the last one.
	XCHG
	LHLD	DIRPOS	;and store it here.
	MOV	M,E	;put low byte.
	INX	H
	MOV	M,D	;then high byte.
	RET
;
;   Check for a read only file.
;
CHKROFL	CALL	FCB2HL	;set (HL) to file entry in directory buffer.
CKROF1	LXI	D,9	;look at bit 7 of the ninth byte.
	DAD	D
	MOV	A,M
	RAL
	RNC		;return if ok.
	LXI	H,ROFILE;else, print error message and terminate.
	JMP	JMPHL
;
;   Check the write protect status of the active disk.
;
CHKWPRT	CALL	GETWPRT
	RZ		;return if ok.
	LXI	H,RODISK;else print message and terminate.
	JMP	JMPHL
;
;   Routine to set (HL) pointing to the proper entry in the
; directory buffer.
;
FCB2HL	LHLD	DIRPTR	;get address of buffer.
	LDA	FCBPOS	;relative position of file.
;
;   Routine to add (A) to (HL).
;
ADDA2HL	ADD	L
	MOV	L,A
	RNC
	INR	H	;take care of any carry.
	RET
;
;   Routine to get the 's2' byte from the fcb supplied in
; the initial parameter specification.
;
GETS2	LHLD	FCBPTR	;get address of fcb.
	LXI	D,14	;relative position of 's2'.
	DAD	D
	MOV	A,M	;extract this byte.
	RET
;
;   Clear the 's2' byte in the fcb.
;
CLEARS2	CALL	GETS2	;this sets (HL) pointing to it.
	MVI	M,0	;now clear it.
	RET
;
;   Set bit 7 in the 's2' byte of the fcb.
;
SETS2B7	CALL	GETS2	;get the byte.
	ORI	80H	;and set bit 7.
	MOV	M,A	;then store.
	RET
;
;   Compare (FPOS) with (DIRPOS) and set flags based on
; the difference. This checks to see if there are more file
; names in the directory. We are at (FPOS) and there are
; (DIRPOS) of them to check.
;
MOREFLS	LHLD	FPOS	;we are here.
	XCHG
	LHLD	DIRPOS	;and don't go past here.
	MOV	A,E	;compute difference but don't keep.
	SUB	M
	INX	H
	MOV	A,D
	SBB	M	;set carry if no more names.
	RET
;
;   Call this routine to prevent (DIRPOS) from being greater than (FPOS).
;
CHKNMBR	CALL	MOREFLS	;DIRPOS too big?
	RC
	INX	D	;yes, reset it to (FPOS).
	MOV	M,D
	DCX	H
	MOV	M,E
	RET

; HL = DE - HL
SUBHL:	MOV	A,E
	SUB	L
	MOV	L,A
	MOV	A,D
	SBB	H
	MOV	H,A
	RET
;
;   Set the directory checksum byte.
;
SETDIR	MVI	C,0FFH
;
;   Routine to set or compare the directory checksum byte. If
; (C)=0ffh, then this will set the checksum byte. Else the byte
; will be checked. If the check fails (the disk has been changed),
; then this disk will be write protected.
;
CHKDIR:	LHLD	CKSBLK
	XCHG
	LHLD	DSKCKS
	CALL	SUBHL
	RNC		;ok if (CKSBLK) > (DSKCKS), so return.
	PUSH	B
	CALL	CKSUM;else compute checksum.
	LHLD	CSVPTR	;get address of checksum table.
	XCHG
	LHLD	CKSBLK
	DAD	D	;set (HL) to point to byte for this drive.
	POP	B
	INR	C	;set or check ?
	JZ	CHKDIR1
	CMP	M	;check them.
	RZ		;return if they are the same.
	CALL	MOREFLS	;not the same, do we care?
	RNC
	CALL	SETRO	;yes, mark this as write protected.
	RET
CHKDIR1	MOV	M,A	;just set the byte.
	RET

; WRITE TO THE DIRECTORY ON DISK
WRDIR:	CALL	SETDIR	;set checksum byte.
	CALL	DIRDMA	; POINT DMA TO DIRECTORY BUFFER
	MVI	C,1	;tell the bios to actually write.
	CALL	WRDSK	; WRITE A SECTOR TO THE DISK
	JMP	DEFDMA	; POINT DMA TO USER BUFFER

; READ FROM THE DIRECTORY ON DISK
RDDIR:	CALL	DIRDMA	; POINT DMA TO DIRECTORY BUFFER
	CALL	RDDSK	; READ A SECTOR FROM THE DISK
; POINT DMA TO USER BUFFER
DEFDMA:	LXI	H,BUFPTR
	JMP	DMAPTR

; POINT DMA TO DIRECTORY BUFFER
DIRDMA:	LXI	H,DIRPTR
DMAPTR:	MOV	C,M
	INX	H
	MOV	B,M
	JMP	SETDMA

; COPY THE DIRECTORY TO THE USER
MOVDIR:	LHLD	DIRPTR
	XCHG
	LHLD	BUFPTR
	MVI	C,128
	JMP	MEMCPY

; SET Z IF FPOS IS 0FFFFH
CKFPOS:	LXI	H,FPOS
	MOV	A,M
	INX	H
	CMP	M
	RNZ
	INR	A
	RET

; SET FPOS TO 0FFFFH
STFPOS:	LXI	H,0FFFFH
	SHLD	FPOS
	RET
;
;   Move on to the next file position within the current
; directory buffer. If no more exist, set pointer to 0ffffh
; and the calling routine will check for this. Enter with (C)
; equal to 0ffh to cause the checksum byte to be set, else we
; will check this disk and set write protect if checksums are
; not the same (applies only if another directory sector must
; be read).
;
NXENTRY	LHLD	DSKDRM	;get directory entry size limit.
	XCHG
	LHLD	FPOS	;get current count.
	INX	H	;go on to the next one.
	SHLD	FPOS
	CALL	SUBHL	;(HL)=(DSKDRM)-(FPOS)
	JNC	NXENT1	;is there more room left?
	JMP	STFPOS;no. Set this flag and return.
NXENT1	LDA	FPOS	;get file position within directory.
	ANI	03H	;only look within this sector (only 4 entries fit).
	MVI	B,5	;convert to relative position (32 bytes each).
NXENT2	ADD	A	;note that this is not efficient code.
	DCR	B	;5 'ADD A's would be better.
	JNZ	NXENT2
	STA	FCBPOS	;save it as position of fcb.
	ORA	A
	RNZ		;return if we are within buffer.
	PUSH	B
	CALL	TRKSEC	;we need the next directory sector.
	CALL	RDDIR
	POP	B
	JMP	CHKDIR
;
;   Routine to to get a bit from the disk space allocation
; map. It is returned in (A), bit position 0. On entry to here,
; set (BC) to the block number on the disk to check.
; On return, (D) will contain the original bit position for
; this block number and (HL) will point to the address for it.
;
CKBITMAP:MOV	A,C	;determine bit number of interest.
	ANI	07H	;compute (D)=(E)=(C and 7)+1.
	INR	A
	MOV	E,A	;save particular bit number.
	MOV	D,A
;
;   compute (BC)=(BC)/8.
;
	MOV	A,C
	RRC		;now shift right 3 bits.
	RRC
	RRC
	ANI	1FH	;and clear bits 7,6,5.
	MOV	C,A
	MOV	A,B
	ADD	A	;now shift (B) into bits 7,6,5.
	ADD	A
	ADD	A
	ADD	A
	ADD	A
	ORA	C	;and add in (C).
	MOV	C,A	;ok, (C) ha been completed.
	MOV	A,B	;is there a better way of doing this?
	RRC
	RRC
	RRC
	ANI	1FH
	MOV	B,A	;and now (B) is completed.
;
;   use this as an offset into the disk space allocation
; table.
;
	LHLD	ALVPTR
	DAD	B
	MOV	A,M	;now get correct byte.
CKBMAP1	RLC		;get correct bit into position 0.
	DCR	E
	JNZ	CKBMAP1
	RET
;
;   Set or clear the bit map such that block number (BC) will be marked
; as used. On entry, if (E)=0 then this bit will be cleared, if it equals
; 1 then it will be set (don't use anyother values).
;
STBITMAP:PUSH	D
	CALL	CKBITMAP;get the byte of interest.
	ANI	0FEH	;clear the affected bit.
	POP	B
	ORA	C	;and now set it acording to (C).
;
;  entry to restore the original bit position and then store
; in table. (A) contains the value, (D) contains the bit
; position (1-8), and (HL) points to the address within the
; space allocation table for this byte.
;
STBMAP1	RRC		;restore original bit position.
	DCR	D
	JNZ	STBMAP1
	MOV	M,A	;and stor byte in table.
	RET
;
;   Set/clear space used bits in allocation map for this file.
; On entry, (C)=1 to set the map and (C)=0 to clear it.
;
SETFILE	CALL	FCB2HL	;get address of fcb
	LXI	D,16
	DAD	D	;get to block number bytes.
	PUSH	B
	MVI	C,17	;check all 17 bytes (max) of table.
SETFL1	POP	D
	DCR	C	;done all bytes yet?
	RZ
	PUSH	D
	LDA	BIGDSK	;check disk size for 16 bit block numbers.
	ORA	A
	JZ	SETFL2
	PUSH	B	;only 8 bit numbers. set (BC) to this one.
	PUSH	H
	MOV	C,M	;get low byte from table, always
	MVI	B,0	;set high byte to zero.
	JMP	SETFL3
SETFL2	DCR	C	;for 16 bit block numbers, adjust counter.
	PUSH	B
	MOV	C,M	;now get both the low and high bytes.
	INX	H
	MOV	B,M
	PUSH	H
SETFL3	MOV	A,C	;block used?
	ORA	B
	JZ	SETFL4
	LHLD	DSKDSM	;is this block number within the
	MOV	A,L	;space on the disk?
	SUB	C
	MOV	A,H
	SBB	B
	CNC	STBITMAP;yes, set the proper bit.
SETFL4	POP	H	;point to next block number in fcb.
	INX	H
	POP	B
	JMP	SETFL1
;
;   Construct the space used allocation bit map for the active
; drive. If a file name starts with '$' and it is under the
; current user number, then (RESULT) is set to minus 1. Otherwise
; it is not set at all.
;
BITMAP	LHLD	DSKDSM	;compute size of allocation table.
	MVI	C,3
	CALL	SHRN	;(HL)=(HL)/8.
	INX	H	;at lease 1 byte.
	MOV	B,H
	MOV	C,L	;set (BC) to the allocation table length.
;
;   Initialize the bitmap for this drive. Right now, the first
; two bytes are specified by the disk parameter block. However
; a patch could be entered here if it were necessary to setup
; this table in a special mannor. For example, the bios could
; determine locations of 'bad blocks' and set them as already
; 'used' in the map.
;
	LHLD	ALVPTR	;now zero out the table now.
BITMAP1	MVI	M,0
	INX	H
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	BITMAP1
	LHLD	DSKALB	;get initial space used by directory.
	XCHG
	LHLD	ALVPTR	;and put this into map.
	MOV	M,E
	INX	H
	MOV	M,D
;
;   End of initialization portion.
;
	CALL	HOME	;now home the drive.
	LHLD	DIRPOS
	MVI	M,3	;force next directory request to read
	INX	H	;in a sector.
	MVI	M,0
	CALL	STFPOS;clear initial file position also.
BITMAP2	MVI	C,0FFH	;read next file name in directory
	CALL	NXENTRY	;and set checksum byte.
	CALL	CKFPOS;is there another file?
	RZ
	CALL	FCB2HL	;yes, get its address.
	MVI	A,0E5H
	CMP	M	;empty file entry?
	JZ	BITMAP2
	LDA	USRNUM	;no, correct user number?
	CMP	M
	JNZ	BITMAP3
	INX	H
	MOV	A,M	;yes, does name start with a '$'?
	SUI	'$'
	JNZ	BITMAP3
	DCR	A	;yes, set atatus to minus one.
	STA	RESULT
BITMAP3	MVI	C,1	;now set this file's space as used in bit map.
	CALL	SETFILE
	CALL	CHKNMBR	;keep (DIRPOS) in bounds.
	JMP	BITMAP2
;
;   Set the status (RESULT) and return.
;
STSTATUS:LDA	FOUND
	JMP	SETRES
;
;   Check extents in (A) and (C). Set the zero flag if they
; are the same. The number of 16k chunks of disk space that
; the directory extent covers is expressad is (DSKEXT+1).
; No registers are modified.
;
SAMEXT	PUSH	B
	PUSH	PSW
	LDA	DSKEXT	;get extent mask and use it to
	CMA		;to compare both extent numbers.
	MOV	B,A	;save resulting mask here.
	MOV	A,C	;mask first extent and save in (C).
	ANA	B
	MOV	C,A
	POP	PSW	;now mask second extent and compare
	ANA	B	;with the first one.
	SUB	C
	ANI	1FH	;(* only check buts 0-4 *)
	POP	B	;the zero flag is set if they are the same.
	RET		;restore (BC) and return.
;
;   Search for the first occurence of a file name. On entry,
; register (C) should contain the number of bytes of the fcb
; that must match.
;
FINDFST	MVI	A,0FFH
	STA	FOUND
	LXI	H,MATCH	;save character count.
	MOV	M,C
	LHLD	FCBPTR	;get filename to match.
	SHLD	SAVEFCB	;and save.
	CALL	STFPOS	;clear initial file position (set to 0ffffh).
	CALL	HOME	;home the drive.
;
;   Entry to locate the next occurence of a filename within the
; directory. The disk is not expected to have been changed. If
; it was, then it will be write protected.
;
FINDNXT	MVI	C,0	;write protect the disk if changed.
	CALL	NXENTRY	;get next filename entry in directory.
	CALL	CKFPOS	;is file position = 0ffffh?
	JZ	FNDNXT6	;yes, exit now then.
	LHLD	SAVEFCB	;set (DE) pointing to filename to match.
	XCHG
	LDAX	D
	CPI	0E5H	;empty directory entry?
	JZ	FNDNXT1	;(* are we trying to reserect erased entries? *)
	PUSH	D
	CALL	MOREFLS	;more files in directory?
	POP	D
	JNC	FNDNXT6	;no more. Exit now.
FNDNXT1	CALL	FCB2HL	;get address of this fcb in directory.
	LDA	MATCH	;get number of bytes (characters) to check.
	MOV	C,A
	MVI	B,0	;initialize byte position counter.
FNDNXT2	MOV	A,C	;are we done with the compare?
	ORA	A
	JZ	FNDNXT5
	LDAX	D	;no, check next byte.
	CPI	'?'	;don't care about this character?
	JZ	FNDNXT4
	MOV	A,B	;get bytes position in fcb.
	CPI	13	;don't care about the thirteenth byte either.
	JZ	FNDNXT4
	CPI	12	;extent byte?
	LDAX	D
	JZ	FNDNXT3
	SUB	M	;otherwise compare characters.
	ANI	7FH
	JNZ	FINDNXT	;not the same, check next entry.
	JMP	FNDNXT4	;so far so good, keep checking.
FNDNXT3	PUSH	B	;check the extent byte here.
	MOV	C,M
	CALL	SAMEXT
	POP	B
	JNZ	FINDNXT	;not the same, look some more.
;
;   So far the names compare. Bump pointers to the next byte
; and continue until all (C) characters have been checked.
;
FNDNXT4	INX	D	;bump pointers.
	INX	H
	INR	B
	DCR	C	;adjust character counter.
	JMP	FNDNXT2
FNDNXT5	LDA	FPOS	;return the position of this entry.
	ANI	03H
	STA	RESULT
	LXI	H,FOUND
	MOV	A,M
	RAL
	RNC
	XRA	A
	MOV	M,A
	RET
;
;   Filename was not found. Set appropriate status.
;
FNDNXT6	CALL	STFPOS	;set (FPOS) to 0ffffh.
	MVI	A,0FFH	;say not located.
	JMP	SETRES
;
;   Erase files from the directory. Only the first byte of the
; fcb will be affected. It is set to (E5).
;
ERAFILE	CALL	CHKWPRT	;is disk write protected?
	MVI	C,12	;only compare file names.
	CALL	FINDFST	;get first file name.
ERAFIL1	CALL	CKFPOS	;any found?
	RZ		;nope, we must be done.
	CALL	CHKROFL	;is file read only?
	CALL	FCB2HL	;nope, get address of fcb and
	MVI	M,0E5H	;set first byte to 'empty'.
	MVI	C,0	;clear the space from the bit map.
	CALL	SETFILE
	CALL	WRDIR;now write the directory sector back out.
	CALL	FINDNXT	;find the next file name.
	JMP	ERAFIL1	;and repeat process.
;
;   Look through the space allocation map (bit map) for the
; next available block. Start searching at block number (BC-1).
; The search procedure is to look for an empty block that is
; before the starting block. If not empty, look at a later
; block number. In this way, we return the closest empty block
; on either side of the 'target' block number. This will speed
; access on random devices. For serial devices, this should be
; changed to look in the forward direction first and then start
; at the front and search some more.
;
;   On return, (DE)= block number that is empty and (HL) =0
; if no empry block was found.
;
FNDSPACE:MOV	D,B	;set (DE) as the block that is checked.
	MOV	E,C
;
;   Look before target block. Registers (BC) are used as the lower
; pointer and (DE) as the upper pointer.
;
FNDSPA1	MOV	A,C	;is block 0 specified?
	ORA	B
	JZ	FNDSPA2
	DCX	B	;nope, check previous block.
	PUSH	D
	PUSH	B
	CALL	CKBITMAP
	RAR		;is this block empty?
	JNC	FNDSPA3	;yes. use this.
;
;   Note that the above logic gets the first block that it finds
; that is empty. Thus a file could be written 'backward' making
; it very slow to access. This could be changed to look for the
; first empty block and then continue until the start of this
; empty space is located and then used that starting block.
; This should help speed up access to some files especially on
; a well used disk with lots of fairly small 'holes'.
;
	POP	B	;nope, check some more.
	POP	D
;
;   Now look after target block.
;
FNDSPA2	LHLD	DSKDSM	;is block (DE) within disk limits?
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JNC	FNDSPA4
	INX	D	;yes, move on to next one.
	PUSH	B
	PUSH	D
	MOV	B,D
	MOV	C,E
	CALL	CKBITMAP;check it.
	RAR		;empty?
	JNC	FNDSPA3
	POP	D	;nope, continue searching.
	POP	B
	JMP	FNDSPA1
;
;   Empty block found. Set it as used and return with (HL)
; pointing to it (true?).
;
FNDSPA3	RAL		;reset byte.
	INR	A	;and set bit 0.
	CALL	STBMAP1	;update bit map.
	POP	H	;set return registers.
	POP	D
	RET
;
;   Free block was not found. If (BC) is not zero, then we have
; not checked all of the disk space.
;
FNDSPA4	MOV	A,C
	ORA	B
	JNZ	FNDSPA1
	LXI	H,0	;set 'not found' status.
	RET
;
;   Move a complete fcb entry into the directory and write it.
;
FCBSET	MVI	C,0
	MVI	E,32	;length of each entry.
;
;   Move (E) bytes from the fcb pointed to by (FCBPTR) into
; fcb in directory starting at relative byte (C). This updated
; directory buffer is then written to the disk.
;
UPDATE	PUSH	D
	MVI	B,0	;set (BC) to relative byte position.
	LHLD	FCBPTR	;get address of fcb.
	DAD	B	;compute starting byte.
	XCHG
	CALL	FCB2HL	;get address of fcb to update in directory.
	POP	B	;set (C) to number of bytes to change.
	CALL	MEMCPY
UPDATE1	CALL	TRKSEC	;determine the track and sector affected.
	JMP	WRDIR	;then write this sector out.
;
;   Routine to change the name of all files on the disk with a
; specified name. The fcb contains the current name as the
; first 12 characters and the new name 16 bytes into the fcb.
;
CHGNAMES:CALL	CHKWPRT	;check for a write protected disk.
	MVI	C,12	;match first 12 bytes of fcb only.
	CALL	FINDFST	;get first name.
	LHLD	FCBPTR	;get address of fcb.
	MOV	A,M	;get user number.
	LXI	D,16	;move over to desired name.
	DAD	D
	MOV	M,A	;keep same user number.
CHGNAM1	CALL	CKFPOS	;any matching file found?
	RZ		;no, we must be done.
	CALL	CHKROFL	;check for read only file.
	MVI	C,16	;start 16 bytes into fcb.
	MVI	E,12	;and update the first 12 bytes of directory.
	CALL	UPDATE
	CALL	FINDNXT	;get te next file name.
	JMP	CHGNAM1	;and continue.
;
;   Update a files attributes. The procedure is to search for
; every file with the same name as shown in fcb (ignoring bit 7)
; and then to update it (which includes bit 7). No other changes
; are made.
;
SAVEATTR:MVI	C,12	;match first 12 bytes.
	CALL	FINDFST	;look for first filename.
SAVATR1	CALL	CKFPOS	;was one found?
	RZ		;nope, we must be done.
	MVI	C,0	;yes, update the first 12 bytes now.
	MVI	E,12
	CALL	UPDATE	;update filename and write directory.
	CALL	FINDNXT	;and get the next file.
	JMP	SAVATR1	;then continue until done.
;
;  Open a file (name specified in fcb).
;
OPENIT	MVI	C,15	;compare the first 15 bytes.
	CALL	FINDFST	;get the first one in directory.
	CALL	CKFPOS	;any at all?
	RZ
OPENIT1	CALL	SETEXT	;point to extent byte within users fcb.
	MOV	A,M	;and get it.
	PUSH	PSW	;save it and address.
	PUSH	H
	CALL	FCB2HL	;point to fcb in directory.
	XCHG
	LHLD	FCBPTR	;this is the users copy.
	MVI	C,32	;move it into users space.
	PUSH	D
	CALL	MEMCPY
	CALL	SETS2B7	;set bit 7 in 's2' byte (unmodified).
	POP	D	;now get the extent byte from this fcb.
	LXI	H,12
	DAD	D
	MOV	C,M	;into (C).
	LXI	H,15	;now get the record count byte into (B).
	DAD	D
	MOV	B,M
	POP	H	;keep the same extent as the user had originally.
	POP	PSW
	MOV	M,A
	MOV	A,C	;is it the same as in the directory fcb?
	CMP	M
	MOV	A,B	;if yes, then use the same record count.
	JZ	OPENIT2
	MVI	A,0	;if the user specified an extent greater than
	JC	OPENIT2	;the one in the directory, then set record count to 0.
	MVI	A,128	;otherwise set to maximum.
OPENIT2	LHLD	FCBPTR	;set record count in users fcb to (A).
	LXI	D,15
	DAD	D	;compute relative position.
	MOV	M,A	;and set the record count.
	RET
;
;   Move two bytes from (DE) to (HL) if (and only if) (HL)
; point to a zero value (16 bit).
;   Return with zero flag set it (DE) was moved. Registers (DE)
; and (HL) are not changed. However (A) is.
;
MOVEWORD:MOV	A,M	;check for a zero word.
	INX	H
	ORA	M	;both bytes zero?
	DCX	H
	RNZ		;nope, just return.
	LDAX	D	;yes, move two bytes from (DE) into
	MOV	M,A	;this zero space.
	INX	D
	INX	H
	LDAX	D
	MOV	M,A
	DCX	D	;don't disturb these registers.
	DCX	H
	RET
;
;   Get here to close a file specified by (fcb).
;
CLOSEIT	XRA	A	;clear status and file position bytes.
	STA	RESULT
	STA	FPOS
	STA	FPOS+1
	CALL	GETWPRT	;get write protect bit for this drive.
	RNZ		;just return if it is set.
	CALL	GETS2	;else get the 's2' byte.
	ANI	80H	;and look at bit 7 (file unmodified?).
	RNZ		;just return if set.
	MVI	C,15	;else look up this file in directory.
	CALL	FINDFST
	CALL	CKFPOS	;was it found?
	RZ		;just return if not.
	LXI	B,16	;set (HL) pointing to records used section.
	CALL	FCB2HL
	DAD	B
	XCHG
	LHLD	FCBPTR	;do the same for users specified fcb.
	DAD	B
	MVI	C,16	;this many bytes are present in this extent.
CLOSEIT1:LDA	BIGDSK	;8 or 16 bit record numbers?
	ORA	A
	JZ	CLOSEIT4
	MOV	A,M	;just 8 bit. Get one from users fcb.
	ORA	A
	LDAX	D	;now get one from directory fcb.
	JNZ	CLOSEIT2
	MOV	M,A	;users byte was zero. Update from directory.
CLOSEIT2:ORA	A
	JNZ	CLOSEIT3
	MOV	A,M	;directories byte was zero, update from users fcb.
	STAX	D
CLOSEIT3:CMP	M	;if neither one of these bytes were zero,
	JNZ	CLOSEIT7	;then close error if they are not the same.
	JMP	CLOSEIT5	;ok so far, get to next byte in fcbs.
CLOSEIT4:CALL	MOVEWORD;update users fcb if it is zero.
	XCHG
	CALL	MOVEWORD;update directories fcb if it is zero.
	XCHG
	LDAX	D	;if these two values are no different,
	CMP	M	;then a close error occured.
	JNZ	CLOSEIT7
	INX	D	;check second byte.
	INX	H
	LDAX	D
	CMP	M
	JNZ	CLOSEIT7
	DCR	C	;remember 16 bit values.
CLOSEIT5:INX	D	;bump to next item in table.
	INX	H
	DCR	C	;there are 16 entries only.
	JNZ	CLOSEIT1;continue if more to do.
	LXI	B,0FFECH;backup 20 places (extent byte).
	DAD	B
	XCHG
	DAD	B
	LDAX	D
	CMP	M	;directory's extent already greater than the
	JC	CLOSEIT6	;users extent?
	MOV	M,A	;no, update directory extent.
	LXI	B,3	;and update the record count byte in
	DAD	B	;directories fcb.
	XCHG
	DAD	B
	MOV	A,M	;get from user.
	STAX	D	;and put in directory.
CLOSEIT6:MVI	A,0FFH	;set 'was open and is now closed' byte.
	STA	CLSFLG
	JMP	UPDATE1	;update the directory now.
CLOSEIT7:LXI	H,RESULT;set return status and then return.
	DCR	M
	RET
;
;   Routine to get the next empty space in the directory. It
; will then be cleared for use.
;
GETEMPTY:CALL	CHKWPRT	;make sure disk is not write protected.
	LHLD	FCBPTR	;save current parameters (fcb).
	PUSH	H
	LXI	H,NULFCB;use special one for empty space.
	SHLD	FCBPTR
	MVI	C,1	;search for first empty spot in directory.
	CALL	FINDFST	;(* only check first byte *)
	CALL	CKFPOS	;none?
	POP	H
	SHLD	FCBPTR	;restore original fcb address.
	RZ		;return if no more space.
	XCHG
	LXI	H,15	;point to number of records for this file.
	DAD	D
	MVI	C,17	;and clear all of this space.
	XRA	A
GETMT1	MOV	M,A
	INX	H
	DCR	C
	JNZ	GETMT1
	LXI	H,13	;clear the 's1' byte also.
	DAD	D
	MOV	M,A
	CALL	CHKNMBR	;keep (DIRPOS) within bounds.
	CALL	FCBSET	;write out this fcb entry to directory.
	JMP	SETS2B7	;set 's2' byte bit 7 (unmodified at present).
;
;   Routine to close the current extent and open the next one
; for reading.
;
GETNEXT	XRA	A
	STA	CLSFLG	;clear close flag.
	CALL	CLOSEIT	;close this extent.
	CALL	CKFPOS
	RZ		;not there???
	LHLD	FCBPTR	;get extent byte.
	LXI	B,12
	DAD	B
	MOV	A,M	;and increment it.
	INR	A
	ANI	1FH	;keep within range 0-31.
	MOV	M,A
	JZ	GTNEXT1	;overflow?
	MOV	B,A	;mask extent byte.
	LDA	DSKEXT
	ANA	B
	LXI	H,CLSFLG;check close flag (0ffh is ok).
	ANA	M
	JZ	GTNEXT2	;if zero, we must read in next extent.
	JMP	GTNEXT3	;else, it is already in memory.
GTNEXT1	LXI	B,2	;Point to the 's2' byte.
	DAD	B
	INR	M	;and bump it.
	MOV	A,M	;too many extents?
	ANI	0FH
	JZ	GTNEXT5	;yes, set error code.
;
;   Get here to open the next extent.
;
GTNEXT2	MVI	C,15	;set to check first 15 bytes of fcb.
	CALL	FINDFST	;find the first one.
	CALL	CKFPOS	;none available?
	JNZ	GTNEXT3
	LDA	RWFLG	;no extent present. Can we open an empty one?
	INR	A	;0ffh means reading (so not possible).
	JZ	GTNEXT5	;or an error.
	CALL	GETEMPTY;we are writing, get an empty entry.
	CALL	CKFPOS	;none?
	JZ	GTNEXT5	;error if true.
	JMP	GTNEXT4	;else we are almost done.
GTNEXT3	CALL	OPENIT1	;open this extent.
GTNEXT4	CALL	STRDATA	;move in updated data (rec #, extent #, etc.)
	XRA	A	;clear status and return.
	JMP	SETRES
;
;   Error in extending the file. Too many extents were needed
; or not enough space on the disk.
;
GTNEXT5	CALL	IOERR1	;set error code, clear bit 7 of 's2'
	JMP	SETS2B7	;so this is not written on a close.

; READ THE NEXT SEQUENTIAL RECORD IN A FILE
RDSEQX	MVI	A,1	;set sequential access mode.
	STA	WRMODE
RDSEQ1	MVI	A,0FFH	;don't allow reading unwritten space.
	STA	RWFLG
	CALL	STRDATA	;put rec# and ext# into fcb.
	LDA	SAVNREC	;get next record to read.
	LXI	H,SAVNXT;get number of records in extent.
	CMP	M	;within this extent?
	JC	RDSEQ2
	CPI	128	;no. Is this extent fully used?
	JNZ	RDSEQ3	;no. End-of-file.
	CALL	GETNEXT	;yes, open the next one.
	XRA	A	;reset next record to read.
	STA	SAVNREC
	LDA	RESULT	;check on open, successful?
	ORA	A
	JNZ	RDSEQ3	;no, error.
RDSEQ2	CALL	BLOCK	;ok. compute block number to read.
	CALL	CHKBLK	;check it. Within bounds?
	JZ	RDSEQ3	;no, error.
	CALL	LOGICAL	;convert (PHYSEC) to logical sector (128 byte).
	CALL	TRKSEC1	;set the track and sector for this block #.
	CALL	RDDSK	; READ A SECTOR FROM THE DISK
	JMP	SETNREC	;and set the next record to be accessed.
;
;   Read error occured. Set status and return.
;
RDSEQ3	JMP	IOERR1

; WRITE THE NEXT SEQUENTIAL RECORD IN A FILE
WTSEQ	MVI	A,1	;set sequential access mode.
	STA	WRMODE
WTSEQ1	MVI	A,0	;allow an addition empty extent to be opened.
	STA	RWFLG
	CALL	CHKWPRT	;check write protect status.
	LHLD	FCBPTR
	CALL	CKROF1	;check for read only file, (HL) already set to fcb.
	CALL	STRDATA	;put updated data into fcb.
	LDA	SAVNREC	;get record number to write.
	CPI	128	;within range?
	JNC	IOERR1	;no, error(?).
	CALL	BLOCK	;compute block number.
	CALL	CHKBLK	;check number.
	MVI	C,0	;is there one to write to?
	JNZ	WTSEQ6	;yes, go do it.
	CALL	BLOCK2	;get next block number within fcb to use.
	STA	RELBLK	;and save.
	LXI	B,0	;start looking for space from the start
	ORA	A	;if none allocated as yet.
	JZ	WTSEQ2
	MOV	C,A	;extract previous block number from fcb
	DCX	B	;so we can be closest to it.
	CALL	EXTBLK
	MOV	B,H
	MOV	C,L
WTSEQ2	CALL	FNDSPACE;find the next empty block nearest number (BC).
	MOV	A,L	;check for a zero number.
	ORA	H
	JNZ	WTSEQ3
	MVI	A,2	;no more space?
	JMP	SETRES
WTSEQ3	SHLD	PHYSEC	;save block number to access.
	XCHG		;put block number into (DE).
	LHLD	FCBPTR	;now we must update the fcb for this
	LXI	B,16	;newly allocated block.
	DAD	B
	LDA	BIGDSK	;8 or 16 bit block numbers?
	ORA	A
	LDA	RELBLK	;(* update this entry *)
	JZ	WTSEQ4	;zero means 16 bit ones.
	CALL	ADDA2HL	;(HL)=(HL)+(A)
	MOV	M,E	;store new block number.
	JMP	WTSEQ5
WTSEQ4	MOV	C,A	;compute spot in this 16 bit table.
	MVI	B,0
	DAD	B
	DAD	B
	MOV	M,E	;stuff block number (DE) there.
	INX	H
	MOV	M,D
WTSEQ5	MVI	C,2	;set (C) to indicate writing to un-used disk space.
WTSEQ6	LDA	RESULT	;are we ok so far?
	ORA	A
	RNZ
	PUSH	B	;yes, save write flag for bios (register C).
	CALL	LOGICAL	;convert (PHYSEC) over to loical sectors.
	LDA	WRMODE	;get access mode flag (1=sequential,
	DCR	A	;0=random, 2=special?).
	DCR	A
	JNZ	WTSEQ9
;
;   Special random i/o from function #40. Maybe for M/PM, but the
; current block, if it has not been written to, will be zeroed
; out and then written (reason?).
;
	POP	B
	PUSH	B
	MOV	A,C	;get write status flag (2=writing unused space).
	DCR	A
	DCR	A
	JNZ	WTSEQ9
	PUSH	H
	LHLD	DIRPTR	;zero out the directory buffer.
	MOV	D,A	;note that (A) is zero here.
WTSEQ7	MOV	M,A
	INX	H
	INR	D	;do 128 bytes.
	JP	WTSEQ7
	CALL	DIRDMA	; POINT DMA TO DIRECTORY BUFFER
	LHLD	LOGSEC	;get sector that starts current block.
	MVI	C,2	;set 'writing to unused space' flag.
WTSEQ8	SHLD	PHYSEC	;save sector to write.
	PUSH	B
	CALL	TRKSEC1	;determine its track and sector numbers.
	POP	B
	CALL	WRDSK	; WRITE A SECTOR TO THE DISK
	LHLD	PHYSEC	;get sector number.
	MVI	C,0	;set normal write flag.
	LDA	DSKBLM	;determine if we have written the entire
	MOV	B,A	;physical block.
	ANA	L
	CMP	B
	INX	H	;prepare for the next one.
	JNZ	WTSEQ8	;continue until (DSKBLM+1) sectors written.
	POP	H	;reset next sector number.
	SHLD	PHYSEC
	CALL	DEFDMA	; POINT DMA TO USER BUFFER
;
;   Normal disk write. Set the desired track and sector then
; do the actual write.
;
WTSEQ9	CALL	TRKSEC1	;determine track and sector for this write.
	POP	B	;get write status flag.
	PUSH	B
	CALL	WRDSK	; WRITE A SECTOR TO THE DISK
	POP	B
	LDA	SAVNREC	;get number of records in file.
	LXI	H,SAVNXT;get last record written.
	CMP	M
	JC	WTSEQ10
	MOV	M,A	;we have to update record count.
	INR	M
	MVI	C,2
;
;*   This area has been patched to correct disk update problem
;* when using blocking and de-blocking in the BIOS.
;
WTSEQ10	NOP		;was 'dcr c'
	NOP		;was 'dcr c'
	LXI	H,0	;was 'jnz wtseq99'
;
; *   End of patch.
;
	PUSH	PSW
	CALL	GETS2	;set 'extent written to' flag.
	ANI	7FH	;(* clear bit 7 *)
	MOV	M,A
	POP	PSW	;get record count for this extent.
WTSEQ99	CPI	127	;is it full?
	JNZ	WTSEQ12
	LDA	WRMODE	;yes, are we in sequential mode?
	CPI	1
	JNZ	WTSEQ12
	CALL	SETNREC	;yes, set next record number.
	CALL	GETNEXT	;and get next empty space in directory.
	LXI	H,RESULT;ok?
	MOV	A,M
	ORA	A
	JNZ	WTSEQ11
	DCR	A	;yes, set record count to -1.
	STA	SAVNREC
WTSEQ11	MVI	M,0	;clear status.
WTSEQ12	JMP	SETNREC	;set next record to access.
;
;   For random i/o, set the fcb for the desired record number
; based on the 'r0,r1,r2' bytes. These bytes in the fcb are
; used as follows:
;
;       fcb+35            fcb+34            fcb+33
;  |     'r-2'      |      'r-1'      |      'r-0'     |
;  |7             0 | 7             0 | 7             0|
;  |0 0 0 0 0 0 0 0 | 0 0 0 0 0 0 0 0 | 0 0 0 0 0 0 0 0|
;  |    overflow   | | extra |  extent   |   record #  |
;  | ______________| |_extent|__number___|_____________|
;                     also 's2'
;
;   On entry, register (C) contains 0ffh if this is a read
; and thus we can not access unwritten disk space. Otherwise,
; another extent will be opened (for writing) if required.
;
POSITION:XRA	A	;set random i/o flag.
	STA	WRMODE
;
;   Special entry (function #40). M/PM ?
;
POSITN1	PUSH	B	;save read/write flag.
	LHLD	FCBPTR	;get address of fcb.
	XCHG
	LXI	H,33	;now get byte 'r0'.
	DAD	D
	MOV	A,M
	ANI	7FH	;keep bits 0-6 for the record number to access.
	PUSH	PSW
	MOV	A,M	;now get bit 7 of 'r0' and bits 0-3 of 'r1'.
	RAL
	INX	H
	MOV	A,M
	RAL
	ANI	1FH	;and save this in bits 0-4 of (C).
	MOV	C,A	;this is the extent byte.
	MOV	A,M	;now get the extra extent byte.
	RAR
	RAR
	RAR
	RAR
	ANI	0FH
	MOV	B,A	;and save it in (B).
	POP	PSW	;get record number back to (A).
	INX	H	;check overflow byte 'r2'.
	MOV	L,M
	INR	L
	DCR	L
	MVI	L,6	;prepare for error.
	JNZ	POSITN5	;out of disk space error.
	LXI	H,32	;store record number into fcb.
	DAD	D
	MOV	M,A
	LXI	H,12	;and now check the extent byte.
	DAD	D
	MOV	A,C
	SUB	M	;same extent as before?
	JNZ	POSITN2
	LXI	H,14	;yes, check extra extent byte 's2' also.
	DAD	D
	MOV	A,B
	SUB	M
	ANI	7FH
	JZ	POSITN3;same, we are almost done then.
;
;  Get here when another extent is required.
;
POSITN2	PUSH	B
	PUSH	D
	CALL	CLOSEIT	;close current extent.
	POP	D
	POP	B
	MVI	L,3	;prepare for error.
	LDA	RESULT
	INR	A
	JZ	POSITN4	;close error.
	LXI	H,12	;put desired extent into fcb now.
	DAD	D
	MOV	M,C
	LXI	H,14	;and store extra extent byte 's2'.
	DAD	D
	MOV	M,B
	CALL	OPENIT	;try and get this extent.
	LDA	RESULT	;was it there?
	INR	A
	JNZ	POSITN3
	POP	B	;no. can we create a new one (writing?).
	PUSH	B
	MVI	L,4	;prepare for error.
	INR	C
	JZ	POSITN4	;nope, reading unwritten space error.
	CALL	GETEMPTY;yes we can, try to find space.
	MVI	L,5	;prepare for error.
	LDA	RESULT
	INR	A
	JZ	POSITN4	;out of space?
;
;   Normal return location. Clear error code and return.
;
POSITN3	POP	B	;restore stack.
	XRA	A	;and clear error code byte.
	JMP	SETRES
;
;   Error. Set the 's2' byte to indicate this (why?).
;
POSITN4	PUSH	H
	CALL	GETS2
	MVI	M,0C0H
	POP	H
;
;   Return with error code (presently in L).
;
POSITN5	POP	B
	MOV	A,L	;get error code.
	STA	RESULT
	JMP	SETS2B7
;
;   Read a random record.
;
READRAN	MVI	C,0FFH	;set 'read' status.
	CALL	POSITION;position the file to proper record.
	CZ	RDSEQ1	;and read it as usual (if no errors).
	RET
;
;   Write to a random record.
;
WRITERAN:MVI	C,0	;set 'writing' flag.
	CALL	POSITION;position the file to proper record.
	CZ	WTSEQ1	;and write as usual (if no errors).
	RET
;
;   Compute the random record number. Enter with (HL) pointing
; to a fcb an (DE) contains a relative location of a record
; number. On exit, (C) contains the 'r0' byte, (B) the 'r1'
; byte, and (A) the 'r2' byte.
;
;   On return, the zero flag is set if the record is within
; bounds. Otherwise, an overflow occured.
;
COMPRAND:XCHG		;save fcb pointer in (DE).
	DAD	D	;compute relative position of record #.
	MOV	C,M	;get record number into (BC).
	MVI	B,0
	LXI	H,12	;now get extent.
	DAD	D
	MOV	A,M	;compute (BC)=(record #)+(extent)*128.
	RRC		;move lower bit into bit 7.
	ANI	80H	;and ignore all other bits.
	ADD	C	;add to our record number.
	MOV	C,A
	MVI	A,0	;take care of any carry.
	ADC	B
	MOV	B,A
	MOV	A,M	;now get the upper bits of extent into
	RRC		;bit positions 0-3.
	ANI	0FH	;and ignore all others.
	ADD	B	;add this in to 'r1' byte.
	MOV	B,A
	LXI	H,14	;get the 's2' byte (extra extent).
	DAD	D
	MOV	A,M
	ADD	A	;and shift it left 4 bits (bits 4-7).
	ADD	A
	ADD	A
	ADD	A
	PUSH	PSW	;save carry flag (bit 0 of flag byte).
	ADD	B	;now add extra extent into 'r1'.
	MOV	B,A
	PUSH	PSW	;and save carry (overflow byte 'r2').
	POP	H	;bit 0 of (L) is the overflow indicator.
	MOV	A,L
	POP	H	;and same for first carry flag.
	ORA	L	;either one of these set?
	ANI	01H	;only check the carry flags.
	RET
;
;   Routine to setup the fcb (bytes 'r0', 'r1', 'r2') to
; reflect the last record used for a random (or other) file.
; This reads the directory and looks at all extents computing
; the largerst record number for each and keeping the maximum
; value only. Then 'r0', 'r1', and 'r2' will reflect this
; maximum record number. This is used to compute the space used
; by a random file.
;
RANSIZE	MVI	C,12	;look thru directory for first entry with
	CALL	FINDFST	;this name.
	LHLD	FCBPTR	;zero out the 'r0, r1, r2' bytes.
	LXI	D,33
	DAD	D
	PUSH	H
	MOV	M,D	;note that (D)=0.
	INX	H
	MOV	M,D
	INX	H
	MOV	M,D
RANSIZ1	CALL	CKFPOS	;is there an extent to process?
	JZ	RANSIZ3	;no, we are done.
	CALL	FCB2HL	;set (HL) pointing to proper fcb in dir.
	LXI	D,15	;point to last record in extent.
	CALL	COMPRAND;and compute random parameters.
	POP	H
	PUSH	H	;now check these values against those
	MOV	E,A	;already in fcb.
	MOV	A,C	;the carry flag will be set if those
	SUB	M	;in the fcb represent a larger size than
	INX	H	;this extent does.
	MOV	A,B
	SBB	M
	INX	H
	MOV	A,E
	SBB	M
	JC	RANSIZ2
	MOV	M,E	;we found a larger (in size) extent.
	DCX	H	;stuff these values into fcb.
	MOV	M,B
	DCX	H
	MOV	M,C
RANSIZ2	CALL	FINDNXT	;now get the next extent.
	JMP	RANSIZ1	;continue til all done.
RANSIZ3	POP	H	;we are done, restore the stack and
	RET		;return.

; SYSTEM FUNCTION #36: SET RANDOM RECORD
SETRAN	LHLD	FCBPTR	;point to fcb.
	LXI	D,32	;and to last used record.
	CALL	COMPRAND;compute random position.
	LXI	H,33	;now stuff these values into fcb.
	DAD	D
	MOV	M,C	;move 'r0'.
	INX	H
	MOV	M,B	;and 'r1'.
	INX	H
	MOV	M,A	;and lastly 'r2'.
	RET
;
;   This routine select the drive specified in (DSKNUM) and
; update the login vector and bitmap table if this drive was
; not already active.
;
LOGDSK:	LHLD	LOGVEC	;get the login vector.
	LDA	DSKNUM	;get the default drive.
	MOV	C,A
	CALL	SHRN	;position active bit for this drive
	PUSH	H	;into bit 0.
	XCHG
	CALL	SELECT	;select this drive.
	POP	H
	CZ	SLCTERR	;valid drive?
	MOV	A,L	;is this a newly activated drive?
	RAR
	RC
	LHLD	LOGVEC	;yes, update the login vector.
	MOV	C,L
	MOV	B,H
	CALL	SETBIT
	SHLD	LOGVEC	;and save.
	JMP	BITMAP	;now update the bitmap.

; SYSTEM FUNCTION #14: SELECT DISK
SETDSK	LDA	EPARAM	;get parameter passed and see if this
	LXI	H,DSKNUM;represents a change in drives.
	CMP	M
	RZ
	MOV	M,A	;yes it does, log it in.
	JMP	LOGDSK

; SELECT THE DISK SPECIFIED IN THE FCB IF NON-ZERO
FCBDSK	MVI	A,0FFH	;say 'auto-select activated'.
	STA	AUTO
	LHLD	FCBPTR	;get drive specified.
	MOV	A,M
	ANI	1FH	;look at lower 5 bits.
	DCR	A	;adjust for (1=A, 2=B) etc.
	STA	EPARAM	;and save for the select routine.
	CPI	1EH	;check for 'no change' condition.
	JNC	AUTOSL1	;yes, don't change.
	LDA	DSKNUM	;we must change, save currently active
	STA	OLDDSK	;drive.
	MOV	A,M	;and save first byte of fcb also.
	STA	AUTOFLAG;this must be non-zero.
	ANI	0E0H	;whats this for (bits 6,7 are used for
	MOV	M,A	;something)?
	CALL	SETDSK	;select and log in this drive.
AUTOSL1	LDA	USRNUM	;move user number into fcb.
	LHLD	FCBPTR	;(* upper half of first byte *)
	ORA	M
	MOV	M,A
	RET		;and return (all done).

; SYSTEM FUNCTION #12: RETURN VERSION NUMBER
GETVER	MVI	A,022h	;version 2.2
	JMP	SETRES

; SYSTEM FUNCTION #13: RESET DISK SYSTEM
RSTDSK	LXI	H,0	;clear write protect status and log
	SHLD	WRTPRT	;in vector.
	SHLD	LOGVEC
	XRA	A	;select drive 'A'.
	STA	DSKNUM
	LXI	H,USRBUF
	;setup default dma address.
	SHLD	BUFPTR
	CALL	DEFDMA	; POINT DMA TO USER BUFFER
	JMP	LOGDSK	;now log in drive 'A'.

; SYSTEM FUNCTION #15: OPEN FILE
OPEN	CALL	CLEARS2	;clear 's2' byte.
	CALL	FCBDSK	;select proper disk.
	JMP	OPENIT	;and open the file.

; SYSTEM FUNCTION #16: CLOSE FILE
CLOSE:CALL	FCBDSK	;select proper disk.
	JMP	CLOSEIT	;and close the file.

; SYSTEM FUNCTION #17: SEARCH FOR FIRST
FIRST	MVI	C,0	;prepare for special search.
	XCHG
	MOV	A,M	;is first byte a '?'?
	CPI	'?'
	JZ	GETFST1	;yes, just get very first entry (zero length match).
	CALL	SETEXT	;get the extension byte from fcb.
	MOV	A,M	;is it '?'? if yes, then we want
	CPI	'?'	;an entry with a specific 's2' byte.
	CNZ	CLEARS2	;otherwise, look for a zero 's2' byte.
	CALL	FCBDSK	;select proper drive.
	MVI	C,15	;compare bytes 0-14 in fcb (12&13 excluded).
GETFST1	CALL	FINDFST	;find an entry and then move it into
	JMP	MOVDIR	;the users dma space.

; SYSTEM FUNCTION #18: SEARCH FOR NEXT
NEXT	LHLD	SAVEFCB	;restore pointers. note that no
	SHLD	FCBPTR	;other dbos calls are allowed.
	CALL	FCBDSK	;no error will be returned, but the
	CALL	FINDNXT	;results will be wrong.
	JMP	MOVDIR

; SYSTEM FUNCTION #19: ERASE (DELETE) A FILE
ERASE	CALL	FCBDSK	;select proper drive.
	CALL	ERAFILE	;erase the file.
	JMP	STSTATUS;set status and return.

; SYSTEM FUNCTION #20: READ THE NEXT SEQUENTIAL RECORD IN A FILE
RDSEQ	CALL	FCBDSK	;select proper drive then read.
	JMP	RDSEQX

; SYSTEM FUNCTION #21: WRITE THE NEXT SEQUENTIAL RECORD IN A FILE
WRSEQ	CALL	FCBDSK	;select proper drive then write.
	JMP	WTSEQ

; SYSTEM FUNCTION #22: MAKE (CREATE) A FILE
MAKE	CALL	CLEARS2	;clear the 's2' byte on all creates.
	CALL	FCBDSK	;select proper drive and get the next
	JMP	GETEMPTY;empty directory space.

; SYSTEM FUNCTION #23: RENAME A FILE
RENAM	CALL	FCBDSK	;select proper drive and then switch
	CALL	CHGNAMES;file names.
	JMP	STSTATUS

; SYSTEM FUNCTION #24: GET THE CURRENT LOGIN VECTOR
GETLOG	LHLD	LOGVEC
	JMP	GETPRM1

; SYSTEM FUNCTION #25: GET THE CURRENT DISK NUMBER
GETDSK	LDA	DSKNUM
	JMP	SETRES

; SYSTEM FUNCTION #26: SET THE DMA POINTER
PUTDMA	XCHG
	SHLD	BUFPTR	;save in our space and then get to
	JMP	DEFDMA	; POINT DMA TO USER BUFFER

; SYSTEM FUNCTION #27: GET THE CURRENT ALLOCATION VECTOR
GETALV	LHLD	ALVPTR
	JMP	GETPRM1

; SYSTEM FUNCTION #29: GET THE CURRENT READ-ONLY VECTOR
GETROV	LHLD	WRTPRT
	JMP	GETPRM1

; SYSTEM FUNCTION #30: SET FILE ATTRIBUTES
SETFIL	CALL	FCBDSK
	CALL	SAVEATTR
	JMP	STSTATUS

; SYSTEM FUNCTION #31: GET THE ADDRESS OF THE DISK PARAMETER BLOCK
GETPB	LHLD	PBPTR
GETPRM1	SHLD	RESULT
	RET

; SYSTEM FUNCTION #32: GET (OR SET) THE CURRENT USER NUMBER
GETUSR	LDA	EPARAM
	CPI	0FFH
	JNZ	SETUSER
	LDA	USRNUM
	JMP	SETRES
; SET THE CURRENT USER NUMBER
SETUSER	ANI	1FH
	STA	USRNUM
	RET

; SYSTEM FUNCTION #33: READ A RANDOM RECORD FROM A FILE
RDRAN:	CALL	FCBDSK
	JMP	READRAN

; SYSTEM FUNCTION #34: WRITE A RANDOM RECORD TO A FILE
WRRAN:	CALL	FCBDSK
	JMP	WRITERAN

; SYSTEM FUNCTION #35: DETERMINE THE SIZE OF A FILE
FILSIZ:CALL	FCBDSK
	JMP	RANSIZE

; SYSTEM FUNCTION #37: RESET DISK
LOGOFF	LHLD	FCBPTR
	MOV	A,L
	CMA
	MOV	E,A
	MOV	A,H
	CMA
	LHLD	LOGVEC
	ANA	H
	MOV	D,A
	MOV	A,L
	ANA	E
	MOV	E,A
	LHLD	WRTPRT
	XCHG
	SHLD	LOGVEC
	MOV	A,L
	ANA	E
	MOV	L,A
	MOV	A,H
	ANA	D
	MOV	H,A
	SHLD	WRTPRT
	RET

; GO BACK TO THE USER
GOBACK:	LDA	AUTO
	ORA	A
	JZ	GOBACK1
	LHLD	FCBPTR
	MVI	M,0
	LDA	AUTOFLAG
	ORA	A
	JZ	GOBACK1
	MOV	M,A
	LDA	OLDDSK
	STA	EPARAM
	CALL	SETDSK
GOBACK1	LHLD	USRSTK
	SPHL
	LHLD	RESULT
	MOV	A,L
	MOV	B,H
	RET

; SYSTEM FUNCTION #40: WRITE RANDOM WITH ZERO FILL
WRRANZ:	CALL	FCBDSK
	MVI	A,2
	STA	WRMODE
	MVI	C,0
	CALL	POSITN1
	CZ	WTSEQ1
	RET
	
;**************************************************************
;*     BDOS data storage pool.
;**************************************************************
;
NULFCB:	DB	0E5H	;empty directory segment indicator.
WRTPRT:	DW	0	;write protect status for all 16 drives.
LOGVEC:	DW	0	;drive active word (1 bit per drive).
BUFPTR:	DW	080H	; POINTER TO USER BUFFER
;
;   Scratch areas from parameter block.
;
DIRPOS:	DW	0	;relative position within dir segment for file (0-3).
TRKNUM:	DW	0	;last selected track number.
SECNUM:	DW	0	;last selected sector number.
;
;   Disk storage areas from parameter block.
;
DIRPTR:	DW	0	; POINTER TO DIRECTORY BUFFER
PBPTR:	DW	0	; POINTER TO DISK PARAMETER BLOCK
CSVPTR:	DW	0	; POINTER TO DIRECTORY CHECKSUM VECTOR
ALVPTR:	DW	0	; POINTER TO ALLOCATION VECTOR
;
;   Disk Parameter block returned from the bios.
;
DSKSPT:	DW	0	;sectors per track from bios.
DSKBHS:	DB	0	;block shift.
DSKBLM:	DB	0	;block mask.
DSKEXT:	DB	0	;extent mask.
DSKDSM:	DW	0	;disk size from bios (number of blocks-1).
DSKDRM:	DW	0	;directory size.
DSKALB:	DW	0	;storage for first bytes of bit map (dir space used).
DSKCKS:	DW	0	;size of CSV
DSKOFF:	DW	0	;first usable track number.
DSKXLT:	DW	0	;sector translation table address.
;
;
CLSFLG:	DB	0	;close flag (=0ffh is extent written ok).
RWFLG:	DB	0	;read/write flag (0ffh=read, 0=write).
FOUND:	DB	0	;filename found status (0=found first entry).
WRMODE	DB	0	;I/o mode select (0=random, 1=sequential, 2=special random).
EPARAM:	DB	0	;storage for register (E) on entry to bdos.
RELBLK:	DB	0	;relative position within fcb of block number written.
MATCH:	DB	0	;byte counter for directory name searches.
SAVEFCB	DW	0,0	;save space for address of fcb (for directory searches).
BIGDSK:	DB	0	;if =0 then disk is > 256 blocks long.
AUTO	DB	0	;if non-zero, then auto select activated.
OLDDSK:	DB	0	;on auto select, storage for previous drive.
AUTOFLAG:DB	0	;if non-zero, then auto select changed drives.
SAVNXT	DB	0	;storage for next record number to access.
SAVEXT	DB	0	;storage for extent number of file.
SAVNREC	DW	0	;storage for number of records in file.
PHYSEC:	DW	0	;block number (physical sector) used within a file or logical sector.
LOGSEC:	DW	0	;starting logical (128 byte) sector of block (physical sector).
FCBPOS:	DB	0	;relative position within buffer for fcb of file of interest.
FPOS:	DW	0	;files position within directory (0 to max entries -1).
CKSBLK:	DW	0

PAD:	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

CODSIZ	EQU	$ - BDOS
NXTADR	EQU	$
